# ******************************************************************************************
# Schubaal's KP_Settings
#	   v2.0 for KnifeP3N 4.5.0+
#
# * Description:
#	   Allows kp_helper to store changes to settings by utilizing a keygroup.
#
# ******************************************************************************************

#**************************************************************
# Do not edit this file unless you really know what you're
#	doing! Please edit the file ./cfg/knifep3n/knifep3n.cfg
#**************************************************************

import es
from es import server_var
import gamethread
import keyvalues

# Register the addon with EventScripts
info = es.AddonInfo()
info.name	  = "KnifeP3N Settings"
info.version  = "2.0"
info.url	  = "http://forums.mattie.info/cs/forums/viewtopic.php?t=19090"
info.basename = "knifep3n/kp_settings"
info.author	  = "Schubaal"

def load():
	# location of es_knifep3n_db.txt to
	global db_filename
	db_filename = "addons/eventscripts/knifep3n/kp_settings/es_knifep3n_db.txt"

	temp = es.exists("keygroup", "knifep3n")
	if temp:
		es.keygroupdelete("knifep3n")
	es.keygroupcreate("knifep3n")
	global kp_settings
	kp_settings = keyvalues.getKeyGroup("knifep3n")
	kp_settings.load(db_filename)
	temp = int(es.exists("key", "knifep3n", "settings"))
	if not temp:
		kp_settings['settings'] = keyvalues.KeyValues(name="settings")
		kp_settings['config_loaded'] = keyvalues.KeyValues(name="config_loaded")
		kp_settings['config_loaded']['ignore_cfg'] = 0
	temp = kp_settings['config_loaded']['ignore_cfg']
	if not temp:
		reload()
	else:
		es.set("knifep3n_chat_filter", kp_settings['settings']['knifep3n_chat_filter'])
		es.set("knifep3n_fight_health", kp_settings['settings']['knifep3n_fight_health'])

		es.set("knifep3n_beacon", kp_settings['settings']['knifep3n_beacon'])
		es.set("knifep3n_beacon_sound", kp_settings['settings']['knifep3n_beacon_sound'])
		es.set("knifep3n_beacon_red_1", kp_settings['settings']['knifep3n_beacon_red_1'])
		es.set("knifep3n_beacon_green_1", kp_settings['settings']['knifep3n_beacon_green_1'])
		es.set("knifep3n_beacon_blue_1", kp_settings['settings']['knifep3n_beacon_blue_1'])
		es.set("knifep3n_beacon_red_2", kp_settings['settings']['knifep3n_beacon_red_2'])
		es.set("knifep3n_beacon_green_2", kp_settings['settings']['knifep3n_beacon_green_2'])
		es.set("knifep3n_beacon_blue_2", kp_settings['settings']['knifep3n_beacon_blue_2'])
		es.set("knifep3n_beacon_rate", kp_settings['settings']['knifep3n_beacon_rate'])
		es.set("knifep3n_beacon_size", kp_settings['settings']['knifep3n_beacon_size'])

		es.set("knifep3n_bot_vote", kp_settings['settings']['knifep3n_bot_vote'])

		es.set("knifep3n_sounds_yes", kp_settings['settings']['knifep3n_sounds_yes'])
		es.set("knifep3n_sounds_no", kp_settings['settings']['knifep3n_sounds_no'])
		es.set("knifep3n_sounds_start", kp_settings['settings']['knifep3n_sounds_start'])
		es.set("knifep3n_sounds_winner", kp_settings['settings']['knifep3n_sounds_winner'])

		es.set("knifep3n_time_limit", kp_settings['settings']['knifep3n_time_limit'])

		es.set("knifep3n_award_money", kp_settings['settings']['knifep3n_award_money'])
		es.set("knifep3n_cash", kp_settings['settings']['knifep3n_cash'])
		es.set("knifep3n_award_health", kp_settings['settings']['knifep3n_award_health'])
		es.set("knifep3n_health", kp_settings['settings']['knifep3n_health'])
		es.set("knifep3n_award_speed", kp_settings['settings']['knifep3n_award_speed'])
		es.set("knifep3n_speed", kp_settings['settings']['knifep3n_speed'])
		es.set("knifep3n_keep_ability", kp_settings['settings']['knifep3n_keep_ability'])

		es.set("knifep3n_teleport", kp_settings['settings']['knifep3n_teleport'])
		es.set("knifep3n_slap", kp_settings['settings']['knifep3n_slap'])
		es.set("knifep3n_keep_weapons", kp_settings['settings']['knifep3n_keep_weapons'])

		es.set("knifep3n_no_vote", kp_settings['settings']['knifep3n_no_vote'])
		es.set("knifep3n_svcheat", kp_settings['settings']['knifep3n_svcheat'])

		es.set("knifep3n_decline_punishment", kp_settings['settings']['knifep3n_decline_punishment'])
		es.set("knifep3n_chicken_red", kp_settings['settings']['knifep3n_chicken_red'])
		es.set("knifep3n_chicken_green", kp_settings['settings']['knifep3n_chicken_green'])
		es.set("knifep3n_chicken_blue", kp_settings['settings']['knifep3n_chicken_blue'])
		es.set("knifep3n_chicken_speed", kp_settings['settings']['knifep3n_chicken_speed'])

		es.set("knifep3n_lame_health", kp_settings['settings']['knifep3n_lame_health'])
		es.set("knifep3n_skin", kp_settings['settings']['knifep3n_skin'])
	gamethread.delayed(1,check_settings)
	gamethread.delayed(2,kp_settings.save(db_filename))

def check_settings():
	if not server_var['knifep3n_time_limit']:
		reload()

def change(keyname,value):
	es.set(str(keyname),str(value))
	kp_settings['settings'][str(keyname)] = str(value)
	kp_settings.save(db_filename)

def getkey(keyname):
	'''
	gets string value of a key
	used for sound names
	'''
	x = str(kp_settings['settings'][str(keyname)])
	return x

def getkeyint(keyname):
	'''
	gets int value of a key
	used for most things
	'''
	x = int(kp_settings['settings'][str(keyname)])
	return x

def getkeyfloat(keyname):
	'''
	gets float value of a key
	used for things like speed
	'''
	x = float(kp_settings['settings'][str(keyname)])
	return x
	
def reload():
	'''
	reads all values from knifep3n.cfg into the knifep3n keygroup
	'''
	es.server.cmd("exec knifep3n/knifep3n.cfg")
	gamethread.delayed(1,create_keygroup)

def adminAdd(userid, command):
	'''
	adds an admin-in-waiting to the keygroup
	used for mani-like say entry of values for kp_helper menu
	'''
	id = str(es.getplayersteamid(userid))
	if es.exists('key', 'knifep3n', id):
		es.keydelete('knifep3n', id)
	kp_settings[id] = keyvalues.KeyValues(name=id)
	kp_settings[id]['command'] = str(command)
	return 1

def adminGet(userid):
	'''
	Checks what command the admin is entering a value for
	'''
	id = str(es.getplayersteamid(userid))
	if es.exists('key', 'knifep3n', id):
		x = str(kp_settings[id]['command'])
		return x
	else:
		return 0

def adminDelete(userid=None):
	'''
	removes user from admin-in-waiting list
	'''
	if userid:
		id = str(es.getplayersteamid(userid))
		if es.exists('key', 'knifep3n', id):
			es.keydelete('knifep3n', id)
	else:
		for k in kp_settings:
			name = k.getName()
			if name != 'settings' and name != 'config_loaded':
				es.keydelete('knifep3n', name)
		kp_settings.save(db_filename)

def create_keygroup():
	kp_settings['settings']['knifep3n_chat_filter'] = server_var['knifep3n_chat_filter']
	kp_settings['settings']['knifep3n_fight_health'] = server_var['knifep3n_fight_health']

	kp_settings['settings']['knifep3n_beacon'] = server_var['knifep3n_beacon']
	kp_settings['settings']['knifep3n_beacon_sound'] = server_var['knifep3n_beacon_sound']
	if not kp_settings['settings']['knifep3n_beacon_sound']:
		kp_settings['settings']['knifep3n_beacon_sound'] = 0
	kp_settings['settings']['knifep3n_beacon_red_1'] = server_var['knifep3n_beacon_red_1']
	kp_settings['settings']['knifep3n_beacon_green_1'] = server_var['knifep3n_beacon_green_1']
	kp_settings['settings']['knifep3n_beacon_blue_1'] = server_var['knifep3n_beacon_blue_1']
	kp_settings['settings']['knifep3n_beacon_red_2'] = server_var['knifep3n_beacon_red_2']
	kp_settings['settings']['knifep3n_beacon_green_2'] = server_var['knifep3n_beacon_green_2']
	kp_settings['settings']['knifep3n_beacon_blue_2'] = server_var['knifep3n_beacon_blue_2']
	kp_settings['settings']['knifep3n_beacon_rate'] = server_var['knifep3n_beacon_rate']
	kp_settings['settings']['knifep3n_beacon_size'] = server_var['knifep3n_beacon_size']

	kp_settings['settings']['knifep3n_bot_vote'] = server_var['knifep3n_bot_vote']
	
	kp_settings['settings']['knifep3n_sounds_yes'] = server_var['knifep3n_sounds_yes']
	if not kp_settings['settings']['knifep3n_sounds_yes']:
		kp_settings['settings']['knifep3n_sounds_yes'] = 0
	kp_settings['settings']['knifep3n_sounds_no'] = server_var['knifep3n_sounds_no']
	if not kp_settings['settings']['knifep3n_sounds_no']:
		kp_settings['settings']['knifep3n_sounds_no'] = 0
	kp_settings['settings']['knifep3n_sounds_start'] = server_var['knifep3n_sounds_start']
	if not kp_settings['settings']['knifep3n_sounds_start']:
		kp_settings['settings']['knifep3n_sounds_start'] = 0
	kp_settings['settings']['knifep3n_sounds_winner'] = server_var['knifep3n_sounds_winner']
	if not kp_settings['settings']['knifep3n_sounds_winner']:
		kp_settings['settings']['knifep3n_sounds_winner'] = 0

	kp_settings['settings']['knifep3n_time_limit'] = server_var['knifep3n_time_limit']
	kp_settings['settings']['knifep3n_award_money'] = server_var['knifep3n_award_money']
	kp_settings['settings']['knifep3n_cash'] = server_var['knifep3n_cash']
	kp_settings['settings']['knifep3n_award_health'] = server_var['knifep3n_award_health']
	kp_settings['settings']['knifep3n_health'] = server_var['knifep3n_health']
	kp_settings['settings']['knifep3n_award_speed'] = server_var['knifep3n_award_speed']
	kp_settings['settings']['knifep3n_speed'] = server_var['knifep3n_speed']
	kp_settings['settings']['knifep3n_keep_ability'] = server_var['knifep3n_keep_ability']

	kp_settings['settings']['knifep3n_teleport'] = server_var['knifep3n_teleport']
	kp_settings['settings']['knifep3n_slap'] = server_var['knifep3n_slap']
	kp_settings['settings']['knifep3n_keep_weapons'] = server_var['knifep3n_keep_weapons']

	kp_settings['settings']['knifep3n_no_vote'] = server_var['knifep3n_no_vote']
	kp_settings['settings']['knifep3n_svcheat'] = server_var['knifep3n_svcheat']

	kp_settings['settings']['knifep3n_decline_punishment'] = server_var['knifep3n_decline_punishment']
	kp_settings['settings']['knifep3n_chicken_red'] = server_var['knifep3n_chicken_red']
	kp_settings['settings']['knifep3n_chicken_green'] = server_var['knifep3n_chicken_green']
	kp_settings['settings']['knifep3n_chicken_blue'] = server_var['knifep3n_chicken_blue']
	kp_settings['settings']['knifep3n_chicken_speed'] = server_var['knifep3n_chicken_speed']

	kp_settings['settings']['knifep3n_lame_health'] = server_var['knifep3n_lame_health']
	kp_settings['settings']['knifep3n_skin'] = server_var['knifep3n_skin']

	kp_settings['config_loaded']['ignore_cfg'] = 1
	kp_settings.save(db_filename)

def unload():
	adminDelete()
	es.keygroupdelete('knifep3n')
