# ******************************************************************************************
# Schubaal's KP_Helper
#		v2.0 for KnifeP3N 4.5.2+
#
# * Description:
#		Adds some functionality and help information to KnifeP3N.
#
# ******************************************************************************************

#**************************************************************
# Do not edit this file unless you really know what you're
#	doing! Please edit the file ./cfg/knifep3n/knifep3n.cfg
#**************************************************************

import es
from es import server_var
import popup, popuplib
import playerlib

import keyvalues

from knifep3n.kp_settings import *

info = es.AddonInfo()
info.name	= "KnifeP3N Helper"
info.version= "2.0"
info.url	= "http://forums.mattie.info/cs/forums/viewtopic.php?t=19090"
info.basename = "knifep3n/kp_helper"
info.author	= "Schubaal"

def load():
	'''
	Initialize popups and say commands
	'''
	# define toggle commands in the toggle parser - DO NOT CHANGE
	global toggle_commands
	toggle_commands = ["", "beacon", "money", "health", "speed", "ability", "teleport", "slap", "weapons", "vote", "svcheat", "punish"]
	global command_list
	command_list = ["", "beacon_color", "beacon_rate", "beacon_size", "fight_health", "lame_health", "time", "awards", "chicken_color", "chicken_speed", "beacon_color1", "beacon_color2"]
	global awards_list
	awards_list = ["cash", "health", "speed"]
	# Say commands
	es.server.cmd('clientcmd create say @kp_reset knifep3n/kp_helper/use_cfg "knifep3n" #admin')
	es.server.cmd('clientcmd create say @kp_force knifep3n/kp_helper/force_fight "knifep3n" #admin')
	es.server.cmd('clientcmd create say @kp_toggle knifep3n/kp_helper/toggle_settings "knifep3n" #admin')
	es.server.cmd('clientcmd create say @kp_filter knifep3n/kp_helper/set_filter "knifep3n" #admin')
	es.server.cmd('clientcmd create say @kp_fight_health knifep3n/kp_helper/set_fight_health "knifep3n" #admin')
	es.server.cmd('clientcmd create say @kp_beacon1 knifep3n/kp_helper/set_beacon1_color "knifep3n" #admin')
	es.server.cmd('clientcmd create say @kp_beacon2 knifep3n/kp_helper/set_beacon2_color "knifep3n" #admin')
	es.server.cmd('clientcmd create say @kp_beacon_rate knifep3n/kp_helper/set_beacon_rate "knifep3n" #admin')
	es.server.cmd('clientcmd create say @kp_beacon_size knifep3n/kp_helper/set_beacon_size "knifep3n" #admin')
	es.server.cmd('clientcmd create say @kp_bots knifep3n/kp_helper/set_bot_vote "knifep3n" #admin')
	es.server.cmd('clientcmd create say @kp_time knifep3n/kp_helper/set_time_limit "knifep3n" #admin')
	es.server.cmd('clientcmd create say @kp_awards knifep3n/kp_helper/set_awards "knifep3n" #admin')
	es.server.cmd('clientcmd create say @kp_chicken_color knifep3n/kp_helper/set_chicken_color "knifep3n" #admin')
	es.server.cmd('clientcmd create say @kp_chicken_speed knifep3n/kp_helper/set_chicken_speed "knifep3n" #admin')
	es.server.cmd('clientcmd create say @kp_lame_health knifep3n/kp_helper/set_lame_health "knifep3n" #admin')

	es.server.cmd('clientcmd create say @kp_helper knifep3n/kp_helper/help "knifep3n" #admin')
	
	# parse catcher
	es.addons.registerSayFilter(say_parser)

	# Popups, lots and lots of popups
	if popuplib.exists('knifep3n_help_1'):
		popuplib.delete('knifep3n_help_1')
	if popuplib.exists('knifep3n_help_2'):
		popuplib.delete('knifep3n_help_2')
	if popuplib.exists('knifep3n_help_reset'):
		popuplib.delete('knifep3n_help_reset')
	if popuplib.exists('knifep3n_help_force'):
		popuplib.delete('knifep3n_help_force')
	if popuplib.exists('knifep3n_help_toggle'):
		popuplib.delete('knifep3n_help_toggle')
	if popuplib.exists('knifep3n_help_toggle_2'):
		popuplib.delete('knifep3n_help_toggle_2')
	if popuplib.exists('knifep3n_help_filter'):
		popuplib.delete('knifep3n_help_filter')
	if popuplib.exists('knifep3n_help_beacon_color'):
		popuplib.delete('knifep3n_help_beacon_color')
	if popuplib.exists('knifep3n_help_beacon'):
		popuplib.delete('knifep3n_help_beacon')
	if popuplib.exists('knifep3n_help_health'):
		popuplib.delete('knifep3n_help_health')
	if popuplib.exists('knifep3n_help_time'):
		popuplib.delete('knifep3n_help_time')
	if popuplib.exists('knifep3n_help_awards'):
		popuplib.delete('knifep3n_help_awards')
	if popuplib.exists('knifep3n_help_chicken'):
		popuplib.delete('knifep3n_help_chicken')
	if popuplib.exists('knifep3n_help_bots'):
		popuplib.delete('knifep3n_help_bots')

	global kp_help_1
	global kp_help_2
	global kp_help_reset
	global kp_help_force
	global kp_help_toggle
	global kp_help_toggle_2
	global kp_help_filter
	global kp_help_beacon_color
	global kp_help_beacon
	global kp_help_health
	global kp_help_time
	global kp_help_awards
	global kp_help_chicken
	global kp_help_bots

	kp_help_1 = popuplib.create('knifep3n_help_1')
	kp_help_1.addline('KnifeP3N Settings Help (1/2)', 'en')
	kp_help_1.addlineAll('---------------------------------------------')
	kp_help_1.addline('->1. @kp_reset', 'en')
	kp_help_1.addline('->2. @kp_force', 'en')
	kp_help_1.addline('->3. @kp_toggle', 'en')
	kp_help_1.addline('->4. @kp_filter', 'en')
	kp_help_1.addline('->5. @kp_beacon1, @kp_beacon2', 'en')
	kp_help_1.addline('->6. @kp_beacon_rate', 'en')
	kp_help_1.addline('->7. @kp_beacon_size', 'en')
	kp_help_1.addline('->9. Next', 'en')
	kp_help_1.addline('0. Close', 'en')
	kp_help_1.submenu(1, 'knifep3n_help_reset')
	kp_help_1.submenu(2, 'knifep3n_help_force')
	kp_help_1.submenu(3, 'knifep3n_help_toggle')
	kp_help_1.submenu(4, 'knifep3n_help_filter')
	kp_help_1.submenu(5, 'knifep3n_help_beacon_color')
	kp_help_1.submenu(6, 'knifep3n_help_beacon')
	kp_help_1.submenu(7, 'knifep3n_help_beacon')
	kp_help_1.submenu(8, 'knifep3n_help_1')
	kp_help_1.submenu(9, 'knifep3n_help_2')

	kp_help_2 = popuplib.create('knifep3n_help_2')
	kp_help_2.addline('KnifeP3N Settings Help (2/2)', 'en')
	kp_help_2.addlineAll('---------------------------------------------')
	kp_help_2.addline('->1. @kp_fight_health', 'en')
	kp_help_2.addline('->2. @kp_lame_health', 'en')
	kp_help_2.addline('->3. @kp_time', 'en')
	kp_help_2.addline('->4. @kp_awards', 'en')
	kp_help_2.addline('->5. @kp_chicken_color', 'en')
	kp_help_2.addline('->6. @kp_chicken_speed', 'en')
	kp_help_2.addline('->7. @kp_bots', 'en')
	kp_help_2.addline('->8. Back', 'en')
	kp_help_2.addline('0. Close', 'en')
	kp_help_2.submenu(1, 'knifep3n_help_health')
	kp_help_2.submenu(2, 'knifep3n_help_health')
	kp_help_2.submenu(3, 'knifep3n_help_time')
	kp_help_2.submenu(4, 'knifep3n_help_awards')
	kp_help_2.submenu(5, 'knifep3n_help_chicken')
	kp_help_2.submenu(6, 'knifep3n_help_chicken')
	kp_help_2.submenu(7, 'knifep3n_help_bots')
	kp_help_2.submenu(8, 'knifep3n_help_1')
	kp_help_2.submenu(9, 'knifep3n_help_2')

	kp_help_reset = popuplib.create('knifep3n_help_reset')
	kp_help_reset.addlineAll(' @kp_reset')
	kp_help_reset.addlineAll('---------------------------------------------')
	kp_help_reset.addline(' Loads settings from the knifep3n/knifep3n.cfg', 'en')
	kp_help_reset.addline('file.', 'en')
	kp_help_reset.addline(' This will overwrite any changes that have', 'en')
	kp_help_reset.addline('been made to the settings in-game.', 'en')
	kp_help_reset.addline('->1. Execute', 'en')
	kp_help_reset.addline('->8. Back', 'en')
	kp_help_reset.addline('0. Close', 'en')
	kp_help_reset.select(1, use_cfg)
	kp_help_reset.submenu(1, 'knifep3n_help_reset')
	kp_help_reset.submenu(2, 'knifep3n_help_reset')
	kp_help_reset.submenu(3, 'knifep3n_help_reset')
	kp_help_reset.submenu(4, 'knifep3n_help_reset')
	kp_help_reset.submenu(5, 'knifep3n_help_reset')
	kp_help_reset.submenu(6, 'knifep3n_help_reset')
	kp_help_reset.submenu(7, 'knifep3n_help_reset')
	kp_help_reset.submenu(8, 'knifep3n_help_1')
	kp_help_reset.submenu(9, 'knifep3n_help_reset')

	kp_help_force = popuplib.create('knifep3n_help_force')
	kp_help_force.addlineAll(' @kp_force')
	kp_help_force.addlineAll('---------------------------------------------')
	kp_help_force.addline(' If there is only one player', 'en')
	kp_help_force.addline('left for each team, then', 'en')
	kp_help_force.addline('they will be forced to fight', 'en')
	kp_help_force.addline('as if no_vote were enabled.', 'en')
	kp_help_force.addline(' This is mainly in case a', 'en')
	kp_help_force.addline('player loses the menu or', 'en')
	kp_help_force.addline('accidentally declines.', 'en')
	kp_help_force.addline('->1. Execute', 'en')
	kp_help_force.addline('->8. Back', 'en')
	kp_help_force.addline('0. Close', 'en')
	kp_help_force.select(1, force_fight)
	kp_help_force.submenu(1, 'knifep3n_help_force')
	kp_help_force.submenu(2, 'knifep3n_help_force')
	kp_help_force.submenu(3, 'knifep3n_help_force')
	kp_help_force.submenu(4, 'knifep3n_help_force')
	kp_help_force.submenu(5, 'knifep3n_help_force')
	kp_help_force.submenu(6, 'knifep3n_help_force')
	kp_help_force.submenu(7, 'knifep3n_help_force')
	kp_help_force.submenu(8, 'knifep3n_help_1')
	kp_help_force.submenu(9, 'knifep3n_help_force')

	kp_help_toggle = popuplib.create('knifep3n_help_toggle')
	kp_help_toggle.addlineAll(' @kp_toggle <option> (1/2)')
	kp_help_toggle.addlineAll('---------------------------------------------')
	kp_help_toggle.addline(' Toggles various on/off options in KnifeP3N', 'en')
	kp_help_toggle.addline('->1. beacon - toggles beacon', 'en')
	kp_help_toggle.addline('->2. money - toggles cash award', 'en')
	kp_help_toggle.addline('->3. health - toggles health award', 'en')
	kp_help_toggle.addline('->4. speed - toggles speed award', 'en')
	kp_help_toggle.addline('->5. ability - keep awards until next fight', 'en')
	kp_help_toggle.addline('->6. teleport - teleport players closer together', 'en')
	kp_help_toggle.addline('->8. Back', 'en')
	kp_help_toggle.addline('->9. Next', 'en')
	kp_help_toggle.addline('0. Close', 'en')
	kp_help_toggle.select(1, toggle_settings)
	kp_help_toggle.select(2, toggle_settings)
	kp_help_toggle.select(3, toggle_settings)
	kp_help_toggle.select(4, toggle_settings)
	kp_help_toggle.select(5, toggle_settings)
	kp_help_toggle.select(6, toggle_settings)
	kp_help_toggle.submenu(1, 'knifep3n_help_toggle')
	kp_help_toggle.submenu(2, 'knifep3n_help_toggle')
	kp_help_toggle.submenu(3, 'knifep3n_help_toggle')
	kp_help_toggle.submenu(4, 'knifep3n_help_toggle')
	kp_help_toggle.submenu(5, 'knifep3n_help_toggle')
	kp_help_toggle.submenu(6, 'knifep3n_help_toggle')
	kp_help_toggle.submenu(7, 'knifep3n_help_toggle')
	kp_help_toggle.submenu(8, 'knifep3n_help_1')
	kp_help_toggle.submenu(9, 'knifep3n_help_toggle_2')

	kp_help_toggle_2 = popuplib.create('knifep3n_help_toggle_2')
	kp_help_toggle_2.addlineAll(' @kp_toggle <option> (2/2)')
	kp_help_toggle_2.addlineAll('---------------------------------------------')
	kp_help_toggle_2.addline(' Toggles various on/off options in KnifeP3N', 'en')
	kp_help_toggle_2.addline('->1. slap - prevents teleport into other player', 'en')
	kp_help_toggle_2.addline('->2. weapons - winner keeps weapons next round', 'en')
	kp_help_toggle_2.addline('->3. vote - auto-fight without vote', 'en')
	kp_help_toggle_2.addline('->4. svcheat - allows cheating', 'en')
	kp_help_toggle_2.addline('->5. punish - punish on decline vote', 'en')
	kp_help_toggle_2.addline('->8. Back', 'en')
	kp_help_toggle_2.addline('0. Close', 'en')
	kp_help_toggle_2.select(1, toggle_settings)
	kp_help_toggle_2.select(2, toggle_settings)
	kp_help_toggle_2.select(3, toggle_settings)
	kp_help_toggle_2.select(4, toggle_settings)
	kp_help_toggle_2.select(5, toggle_settings)
	kp_help_toggle_2.submenu(1, 'knifep3n_help_toggle_2')
	kp_help_toggle_2.submenu(2, 'knifep3n_help_toggle_2')
	kp_help_toggle_2.submenu(3, 'knifep3n_help_toggle_2')
	kp_help_toggle_2.submenu(4, 'knifep3n_help_toggle_2')
	kp_help_toggle_2.submenu(5, 'knifep3n_help_toggle_2')
	kp_help_toggle_2.submenu(6, 'knifep3n_help_toggle_2')
	kp_help_toggle_2.submenu(7, 'knifep3n_help_toggle_2')
	kp_help_toggle_2.submenu(8, 'knifep3n_help_toggle')
	kp_help_toggle_2.submenu(9, 'knifep3n_help_toggle_2')

	kp_help_filter = popuplib.create('knifep3n_help_filter')
	kp_help_filter.addlineAll(' @kp_filter <value>')
	kp_help_filter.addlineAll('---------------------------------------------')
	kp_help_filter.addline(' Sets the level of the chat spam filter.', 'en')
	kp_help_filter.addline('->1. send all chat messages (0)', 'en')
	kp_help_filter.addline('->2. send only important chat messages (1)', 'en')
	kp_help_filter.addline('->3. send no chat messages (2)', 'en')
	kp_help_filter.addline('->8. Back', 'en')
	kp_help_filter.addline('0. Close', 'en')
	kp_help_filter.submenu(1, 'knifep3n_help_filter')
	kp_help_filter.submenu(2, 'knifep3n_help_filter')
	kp_help_filter.submenu(3, 'knifep3n_help_filter')
	kp_help_filter.submenu(4, 'knifep3n_help_filter')
	kp_help_filter.submenu(5, 'knifep3n_help_filter')
	kp_help_filter.submenu(6, 'knifep3n_help_filter')
	kp_help_filter.submenu(7, 'knifep3n_help_filter')
	kp_help_filter.submenu(8, 'knifep3n_help_1')
	kp_help_filter.submenu(9, 'knifep3n_help_filter')
	kp_help_filter.select(1, set_filter)
	kp_help_filter.select(2, set_filter)
	kp_help_filter.select(3, set_filter)

	kp_help_beacon_color = popuplib.create('knifep3n_help_beacon_color')
	kp_help_beacon_color.addline('->1. @kp_beacon1 <red> <green> <blue>', 'en')
	kp_help_beacon_color.addline('->2. @kp_beacon2 <red> <green> <blue>', 'en')
	kp_help_beacon_color.addlineAll('---------------------------------------------')
	kp_help_beacon_color.addline(' Sets the color of T (1) and CT (2)', 'en')
	kp_help_beacon_color.addline('beacons.', 'en')
	kp_help_beacon_color.addline(' <red> <green> <blue> can each be set', 'en')
	kp_help_beacon_color.addline('between 0 and 255 to determine the', 'en')
	kp_help_beacon_color.addline('color of a beacon.', 'en')
	kp_help_beacon_color.addline('->8. Back', 'en')
	kp_help_beacon_color.addline('0. Close', 'en')
	kp_help_beacon_color.select(1, popup_parser)
	kp_help_beacon_color.select(2, popup_parser)
	kp_help_beacon_color.submenu(1, 'knifep3n_help_beacon_color')
	kp_help_beacon_color.submenu(2, 'knifep3n_help_beacon_color')
	kp_help_beacon_color.submenu(3, 'knifep3n_help_beacon_color')
	kp_help_beacon_color.submenu(4, 'knifep3n_help_beacon_color')
	kp_help_beacon_color.submenu(5, 'knifep3n_help_beacon_color')
	kp_help_beacon_color.submenu(6, 'knifep3n_help_beacon_color')
	kp_help_beacon_color.submenu(7, 'knifep3n_help_beacon_color')
	kp_help_beacon_color.submenu(8, 'knifep3n_help_1')
	kp_help_beacon_color.submenu(9, 'knifep3n_help_beacon_color')

	kp_help_beacon = popuplib.create('knifep3n_help_beacon')
	kp_help_beacon.addline('->1. @kp_beacon_rate <float seconds>', 'en')
	kp_help_beacon.addlineAll('---------------------------------------------')
	kp_help_beacon.addline(' Sets how often (in seconds, on average)', 'en')
	kp_help_beacon.addline('beacons will emit from players in a', 'en')
	kp_help_beacon.addline('knife fight.', 'en')
	kp_help_beacon.addlineAll('---------------------------------------------')
	kp_help_beacon.addlineAll('->2. @kp_beacon_size <integer>')
	kp_help_beacon.addlineAll('---------------------------------------------')
	kp_help_beacon.addline(' Sets the radius of the visual beacons', 'en')
	kp_help_beacon.addline('that emit from players.', 'en')
	kp_help_beacon.addline(' 100 ~ 1.22m ~ 4ft', 'en')
	kp_help_beacon.addline('->8. Back', 'en')
	kp_help_beacon.addline('0. Close', 'en')
	kp_help_beacon.select(1, popup_parser)
	kp_help_beacon.select(2, popup_parser)
	kp_help_beacon.submenu(1, 'knifep3n_help_beacon')
	kp_help_beacon.submenu(2, 'knifep3n_help_beacon')
	kp_help_beacon.submenu(3, 'knifep3n_help_beacon')
	kp_help_beacon.submenu(4, 'knifep3n_help_beacon')
	kp_help_beacon.submenu(5, 'knifep3n_help_beacon')
	kp_help_beacon.submenu(6, 'knifep3n_help_beacon')
	kp_help_beacon.submenu(7, 'knifep3n_help_beacon')
	kp_help_beacon.submenu(8, 'knifep3n_help_1')
	kp_help_beacon.submenu(9, 'knifep3n_help_beacon')

	kp_help_health = popuplib.create('knifep3n_help_health')
	kp_help_health.addlineAll('->1. @kp_fight_health <int>')
	kp_help_health.addlineAll('---------------------------------------------')
	kp_help_health.addline(' Sets how much health players get at the', 'en')
	kp_help_health.addline('start of a knife fight.', 'en')
	kp_help_health.addlineAll('---------------------------------------------')
	kp_help_health.addlineAll('->2. @kp_lame_health <int>')
	kp_help_health.addlineAll('---------------------------------------------')
	kp_help_health.addline(' Sets how much health a player spawns', 'en')
	kp_help_health.addline('with on a round following a suicide', 'en')
	kp_help_health.addline('during a knife fight.', 'en')
	kp_help_health.addline('->8. Back', 'en')
	kp_help_health.addline('0. Close', 'en')
	kp_help_health.select(1, popup_parser)
	kp_help_health.select(2, popup_parser)
	kp_help_health.submenu(1, 'knifep3n_help_health')
	kp_help_health.submenu(2, 'knifep3n_help_health')
	kp_help_health.submenu(3, 'knifep3n_help_health')
	kp_help_health.submenu(4, 'knifep3n_help_health')
	kp_help_health.submenu(5, 'knifep3n_help_health')
	kp_help_health.submenu(6, 'knifep3n_help_health')
	kp_help_health.submenu(7, 'knifep3n_help_health')
	kp_help_health.submenu(8, 'knifep3n_help_2')
	kp_help_health.submenu(9, 'knifep3n_help_health')

	kp_help_time = popuplib.create('knifep3n_help_time')
	kp_help_time.addlineAll('->1. @kp_time <int>')
	kp_help_time.addlineAll('---------------------------------------------')
	kp_help_time.addline(' Sets how long (in seconds) players have for', 'en')
	kp_help_time.addline('a fight.', 'en')
	kp_help_time.addline('->8. Back', 'en')
	kp_help_time.addline('0. Close', 'en')
	kp_help_time.select(1, popup_parser)
	kp_help_time.submenu(1, 'knifep3n_help_time')
	kp_help_time.submenu(2, 'knifep3n_help_time')
	kp_help_time.submenu(3, 'knifep3n_help_time')
	kp_help_time.submenu(4, 'knifep3n_help_time')
	kp_help_time.submenu(5, 'knifep3n_help_time')
	kp_help_time.submenu(6, 'knifep3n_help_time')
	kp_help_time.submenu(7, 'knifep3n_help_time')
	kp_help_time.submenu(8, 'knifep3n_help_2')
	kp_help_time.submenu(9, 'knifep3n_help_time')

	kp_help_bots = popuplib.create('knifep3n_help_bots')
	kp_help_bots.addlineAll(' @kp_bots <int>')
	kp_help_bots.addlineAll('---------------------------------------------')
	kp_help_bots.addline(' Sets bot voting behavior.', 'en')
	kp_help_bots.addline('->1. Always vote yes', 'en')
	kp_help_bots.addline('->2. Vote yes half of the time', 'en')
	kp_help_bots.addline('->3. Vote yes 66% of the time', 'en')
	kp_help_bots.addline('->4. Always vote no', 'en')
	kp_help_bots.addline('->8. Back', 'en')
	kp_help_bots.addline('0. Close', 'en')
	kp_help_bots.submenu(1, 'knifep3n_help_bots')
	kp_help_bots.submenu(2, 'knifep3n_help_bots')
	kp_help_bots.submenu(3, 'knifep3n_help_bots')
	kp_help_bots.submenu(4, 'knifep3n_help_bots')
	kp_help_bots.submenu(5, 'knifep3n_help_bots')
	kp_help_bots.submenu(6, 'knifep3n_help_bots')
	kp_help_bots.submenu(7, 'knifep3n_help_bots')
	kp_help_bots.submenu(8, 'knifep3n_help_2')
	kp_help_bots.submenu(9, 'knifep3n_help_bots')
	kp_help_bots.select(1, menu_bot_vote)
	kp_help_bots.select(2, menu_bot_vote)
	kp_help_bots.select(3, menu_bot_vote)
	kp_help_bots.select(4, menu_bot_vote)

	kp_help_awards = popuplib.create('knifep3n_help_awards')
	kp_help_awards.addlineAll(' @kp_awards <option> <param>')
	kp_help_awards.addlineAll('---------------------------------------------')
	kp_help_awards.addline(' <options>', 'en')
	kp_help_awards.addline('->1. cash - sets how much money a winner ', 'en')
	kp_help_awards.addline('           receives', 'en')
	kp_help_awards.addline('    money - same as cash', 'en')
	kp_help_awards.addline('        <param> from 0 to 16000', 'en')
	kp_help_awards.addline('->2. health - sets how much health a winner', 'en')
	kp_help_awards.addline('           will spawn with', 'en')
	kp_help_awards.addline('    hp - same as health', 'en')
	kp_help_awards.addline('        <param> from 1 to ???', 'en')
	kp_help_awards.addline("->3. speed - sets the how much the winner's", 'en')
	kp_help_awards.addline('           speed will be multiplied by', 'en')
	kp_help_awards.addline('        <param> from 0.0 (frozen) to 5.0 (fast)', 'en')
	kp_help_awards.addline('->8. Back', 'en')
	kp_help_awards.addline('0. Close', 'en')
	kp_help_awards.select(1, popup_parser)
	kp_help_awards.select(2, popup_parser)
	kp_help_awards.select(3, popup_parser)
	kp_help_awards.submenu(1, 'knifep3n_help_awards')
	kp_help_awards.submenu(2, 'knifep3n_help_awards')
	kp_help_awards.submenu(3, 'knifep3n_help_awards')
	kp_help_awards.submenu(4, 'knifep3n_help_awards')
	kp_help_awards.submenu(5, 'knifep3n_help_awards')
	kp_help_awards.submenu(6, 'knifep3n_help_awards')
	kp_help_awards.submenu(7, 'knifep3n_help_awards')
	kp_help_awards.submenu(8, 'knifep3n_help_2')
	kp_help_awards.submenu(9, 'knifep3n_help_awards')

	kp_help_chicken = popuplib.create('knifep3n_help_chicken')
	kp_help_chicken.addline('->1. @kp_chicken_color <red> <green> <blue>', 'en')
	kp_help_chicken.addlineAll('---------------------------------------------')
	kp_help_chicken.addline(' Sets the color of chickens!', 'en')
	kp_help_chicken.addline(' <red> <green> <blue> can each be set', 'en')
	kp_help_chicken.addline('between 0 and 255 to determine the', 'en')
	kp_help_chicken.addline("color of a player who's a chicken.", 'en')
	kp_help_chicken.addlineAll('---------------------------------------------')
	kp_help_chicken.addlineAll('->2. @kp_chicken_speed <float>')
	kp_help_chicken.addlineAll('---------------------------------------------')
	kp_help_chicken.addline(" Sets the speed of a player who's a chicken.", 'en')
	kp_help_chicken.addline('<float> from 0.0 (frozen) to 5.0 (fast)', 'en')
	kp_help_chicken.addline('->8. Back', 'en')
	kp_help_chicken.addline('0. Close', 'en')
	kp_help_chicken.select(1, popup_parser)
	kp_help_chicken.select(2, popup_parser)
	kp_help_chicken.submenu(1, 'knifep3n_help_chicken')
	kp_help_chicken.submenu(2, 'knifep3n_help_chicken')
	kp_help_chicken.submenu(3, 'knifep3n_help_chicken')
	kp_help_chicken.submenu(4, 'knifep3n_help_chicken')
	kp_help_chicken.submenu(5, 'knifep3n_help_chicken')
	kp_help_chicken.submenu(6, 'knifep3n_help_chicken')
	kp_help_chicken.submenu(7, 'knifep3n_help_chicken')
	kp_help_chicken.submenu(8, 'knifep3n_help_1')
	kp_help_chicken.submenu(9, 'knifep3n_help_chicken')

def help():
	'''
	Send the @kp_helper menu
	'''
	userid = es.getcmduserid()
	kp_help_1.send(userid)

def use_cfg(userid=None, pchoice=None, pname=None):
	'''
	Tells kp_settings to load all keygroup values from the knifep3n.cfg
	'''
	kp_settings.reload()
	if not userid:
		userid = es.getcmduserid()
	es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen Settings have been restored from knifep3n.cfg!')
 
def menu_bot_vote(userid, x, pname):
	''' 
	change bot vote via menu
	1 = vote yes 100%
	2 = vote yes 50%
	3 = vote yes 66%
	4 = always vote no
	'''
	if x > 0 and x < 5:
		kp_settings.change('knifep3n_bot_vote', x)
		es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen Bot voting has been set to '+str(x))
 
def force_fight(userid=None, pchoice=None, pname=None):
	'''
	@kp_force or execute via menu, forces a knife fight
	'''
	# first check to make sure there's only one player on each team and no vote isn't already on
	if (int(server_var['knifep3n_no_vote']) == 0):
		if es.getlivingplayercount(2) == 1 and es.getlivingplayercount(3) == 1:
			# reset any current settings in case someone already voted yes/no
			es.set("knifep3n_acc", 0)
			es.set("knifep3n_dec", 0)
			es.set("knifep3n_get_player", 0)
			# set no vote
			es.set("knifep3n_no_vote", 1)
			## re-enable thiese when knifep3n is written in ESP
			#for x in playerlib.getPlayerList('#alive'):
				#knifep3n.bot_votedyes()
				# temporary, until knifep3n.bot_votedyes() exists
			# trigger auto-votes
			es.server.cmd('foreach player tempuserid #alive "es_xdoblock knifep3n/bot_votedyes"')
			es.set("knifep3n_menu_sent", 1)
			# set no_vote back to 0
			es.set('knifep3n_no_vote', 0)
		else:
			if not userid:
				userid = es.getcmduserid()
			es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen There must be one player alive on each team to force a fight!')
	else:
		if not userid:
			userid = es.getcmduserid()
		es.tell(userid, '#multi', "#green[KP_Helper]#lightgreen No vote is already on, there's no need to force a fight manually.")

def toggle_settings(userid=None, pchoice=None, pname=None):
	'''
	toggle on/off settings via @kp_toggle <option> or from menu
	'''
	# if a popup was used, get its vars
	if pname:
		if (pname == "knifep3n_help_toggle"):
			x = str(toggle_commands[pchoice])
		elif (pname == "knifep3n_help_toggle_2"):
			x = str(toggle_commands[pchoice+6])
		else:
			x = "ignore"
	# otherwise it should be a say command
	else:
		userid = es.getcmduserid()
		x = str(es.getargv(1))

	if x == "beacon":
		if kp_settings.getkeyint('knifep3n_beacon'):
			kp_settings.change('knifep3n_beacon', 0)
			es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen Beacons during knife fights have been disabled.')
		else:
			kp_settings.change('knifep3n_beacon', 1)
			es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen Knife fighters will be turned into beacons.')
	elif x == "money":
		if kp_settings.getkeyint('knifep3n_award_money'):
			kp_settings.change('knifep3n_award_money', 0)
			es.tell(userid, '#multi', "#green[KP_Helper]#lightgreen Winners won't receive bonus cash.")
		else:
			kp_settings.change('knifep3n_award_money', 1)
			es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen Winners will receive bonus cash.')
	elif x == "health":
		if kp_settings.getkeyint('knifep3n_award_health'):
			kp_settings.change('knifep3n_award_health', 0)
			es.tell(userid, '#multi', "#green[KP_Helper]#lightgreen Winners won't receive a health bonus.")
		else:
			kp_settings.change('knifep3n_award_health', 1)
			es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen Winners get a health bonus.')
	elif x == "speed":
		if kp_settings.getkeyint('knifep3n_award_speed'):
			kp_settings.change('knifep3n_award_speed', 0)
			es.tell(userid, '#multi', "#green[KP_Helper]#lightgreen Winnerss won't receive a speed bonus.")
		else:
			kp_settings.change('knifep3n_award_speed', 1)
			es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen Winners get a speed bonus.')
	elif x == "ability":
		if kp_settings.getkeyint('knifep3n_keep_ability'):
			kp_settings.change('knifep3n_keep_ability', 0)
			es.tell(userid, '#multi', "#green[KP_Helper]#lightgreen Winners don't keep their winner awards between rounds.")
		else:
			kp_settings.change('knifep3n_keep_ability', 1)
			es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen Winners keep their awards until the next knife fight.')
	elif x == "teleport":
		if kp_settings.getkeyint('knifep3n_teleport'):
			kp_settings.change('knifep3n_teleport', 0)
			es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen Players will not be teleported for a knife fight.')
		else:
			kp_settings.change('knifep3n_teleport', 1)
			es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen Players will be teleported closer together before a knife fight.')
	elif x == "slap":
		if kp_settings.getkeyint('knifep3n_slap'):
			kp_settings.change('knifep3n_slap', 0)
			es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen The first player to accept knife fight is no longer slapped.')
		else:
			if kp_settings.getkeyint('knifep3n_teleport'):
				kp_settings.change('knifep3n_slap', 1)
				es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen The first player to accept knife fight will be slapped.')
	elif x == "weapons":
		if kp_settings.getkeyint('knifep3n_keep_weapons'):
			kp_settings.change('knifep3n_keep_weapons', 0)
			es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen The winner of a knife fight will not keep his weapons for next round.')
		else:
			kp_settings.change('knifep3n_keep_weapons', 1)
			es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen The winner of a knife fight keeps his weapons for the next round.')
	elif x == "vote":
		if kp_settings.getkeyint('knifep3n_no_vote'):
			kp_settings.change('knifep3n_no_vote', 0)
			es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen No vote has been turned off, knife fights are no longer enforced.')
		else:
			kp_settings.change('knifep3n_no_vote', 1)
			es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen No vote has been turned on, knife fights are no longer optional.')
	elif x == "svcheat":
		if kp_settings.getkeyint('knifep3n_svcheat'):
			kp_settings.change('knifep3n_svcheat', 0)
			es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen Cheating has been enabled. Weapons are no longer stripped during knife fights.')
		else:
			kp_settings.change('knifep3n_svcheat', 1)
			es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen Cheating has been disabled. Weapons are removed if picked up during knife fights.')
	elif x == "punish":
		if kp_settings.getkeyint('knifep3n_decline_punishment'):
			kp_settings.change('knifep3n_decline_punishment', 0)
			es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen Punishment for chickens has been disabled.')
		else:
			kp_settings.change('knifep3n_decline_punishment', 1)
			es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen Punishment for chickens has been enabled.')
	elif x == "ignore":
		es.tell(userid, '#green', '[KP_Helper] ERROR - somehow, the incorrect popup triggered this block. Contact Schubaal.')
		es.tell(userid, '#green', '[Debug] toggle_settings; pname '+pname+'__'+pchoice)
	else:
		es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen Type @kp_helper for help.')

def set_filter(userid=None, pchoice=None, pname=None):
	'''
	Set the chat filter
	menu/saycmd
	1/0 = no filter
	2/1 = filter some
	3/2 = filter all
	'''
	# if it's from the menu, set var
	if (pname == "knifep3n_help_filter"):
		if (pchoice == 3):
			x = 2
		elif (pchoice == 2):
			x = 1
		elif (pchoice == 1):
			x = 0
		else:
			x = "ignore"
	else:
		userid = es.getcmduserid()
		x = int(es.getargv(1))

	if x >= 0 and x <= 2:
		es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen Chat filter changed to '+str(x))
		kp_settings.change('knifep3n_chat_filter', x)
	elif (x == "ignore"):
		pass
	else:
		es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen Type @kp_helper for help.')
	
 
def set_beacon1_color():
	'''
	Set the color of Terrorist beacon
		menu support in popup_parser
	'''
	userid = es.getcmduserid()
	# needs 4 args, command plus RGB colors
	if (es.getargc() == 4):
		try:
			r = int(es.getargv(1))
			g = int(es.getargv(2))
			b = int(es.getargv(3))
		except ValueError:
			es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen You entered an invalid value for Terrorist beacon color.')
			return
		if (r > 255):
			r = 255
		if (r < 0):
			r = 0
		if (g > 255):
			g = 255
		if (g < 0):
			g = 0
		if (b > 255):
			b = 255
		if (b < 0):
			b = 0
		es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen T beacon color is '+str(r)+' '+str(g)+' '+str(b))

		kp_settings.change('knifep3n_beacon_red_1', r)
		kp_settings.change('knifep3n_beacon_green_1', g)
		kp_settings.change('knifep3n_beacon_blue_1', b)
	elif (es.getargc() == 2):
		parts = str(es.getargv(1)).split(' ',2)
		try:
			r = int(parts[0])
			g = int(parts[1])
			b = int(parts[2])
		except ValueError:
			es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen You entered an invalid value for Terrorist beacon color.')
			return
		if (r > 255):
			r = 255
		if (r < 0):
			r = 0
		if (g > 255):
			g = 255
		if (g < 0):
			g = 0
		if (b > 255):
			b = 255
		if (b < 0):
			b = 0
		es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen T beacon color is '+str(r)+' '+str(g)+' '+str(b))
		
		kp_settings.change('knifep3n_beacon_red_2', r)
		kp_settings.change('knifep3n_beacon_green_2', g)
		kp_settings.change('knifep3n_beacon_blue_2', b)
	else:
		es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen Type @kp_helper for help.')
	
 
def set_beacon2_color():
	'''
	Set the color of Counter-Terrorist beacon
		menu support in popup_parser
	'''
	userid = es.getcmduserid()
	# needs 4 args, command plus RGB colors
	if (es.getargc() == 4):
		try:
			r = int(es.getargv(1))
			g = int(es.getargv(2))
			b = int(es.getargv(3))
		except ValueError:
			es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen You entered an invalid value for Counter-Terrorist beacon color.')
			return
		if (r > 255):
			r = 255
		if (r < 0):
			r = 0
		if (g > 255):
			g = 255
		if (g < 0):
			g = 0
		if (b > 255):
			b = 255
		if (b < 0):
			b = 0
		es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen CT beacon color is '+str(r)+' '+str(g)+' '+str(b))
		
		kp_settings.change('knifep3n_beacon_red_2', r)
		kp_settings.change('knifep3n_beacon_green_2', g)
		kp_settings.change('knifep3n_beacon_blue_2', b)
	elif (es.getargc() == 2):
		parts = str(es.getargv(1)).split(' ',2)
		try:
			r = int(parts[0])
			g = int(parts[1])
			b = int(parts[2])
		except ValueError:
			es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen You entered an invalid value for Counter-Terrorist beacon color.')
			return
		if (r > 255):
			r = 255
		if (r < 0):
			r = 0
		if (g > 255):
			g = 255
		if (g < 0):
			g = 0
		if (b > 255):
			b = 255
		if (b < 0):
			b = 0
		es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen CT beacon color is '+str(r)+' '+str(g)+' '+str(b))
		
		kp_settings.change('knifep3n_beacon_red_2', r)
		kp_settings.change('knifep3n_beacon_green_2', g)
		kp_settings.change('knifep3n_beacon_blue_2', b)
	else:
		es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen Type @kp_helper for help.')
 
def set_fight_health():
	'''
	Set how much health players get at the start of a knife fight
		menu support in popup_parser
	'''
	userid = es.getcmduserid()
	# needs 2 args, command and health
	if (es.getargc() == 2):
		try:
			x = int(es.getargv(1))
			# don't set health lower than 1
			if x < 1:
				x = 1
		except ValueError:
			es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen You entered an invalid value for fight health.')
			return
		kp_settings.change('knifep3n_fight_health', x)
		es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen Fight health has been set to '+str(x))
	else:
		es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen Type @kp_helper for help.')
	
 
def set_beacon_rate():
	'''
	Set approximately how often beacon is emitted from fighters
		menu support in popup_parser
	'''
	userid = es.getcmduserid()
	# needs 2 args, command and rate
	if (es.getargc() == 2):
		try:
			x = float(es.getargv(1))
		except ValueError:
			es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen You entered an invalid value for beacon rate.')
			return
		# don't set rate lower than half a second
		if x < 0.5:
			x = 0.5
		kp_settings.change('knifep3n_beacon_rate', x)
		es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen Beacons are emitted from fighters about every '+str(x)+' seconds.')
	else:
		es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen Type @kp_helper for help.')
	
 
def set_beacon_size():
	'''
	Set radius of the visual beacon
		menu support in popup_parser
	'''
	userid = es.getcmduserid()
	# needs 2 args, command and radius
	if (es.getargc() == 2):
		try:
			x = int(es.getargv(1))
		except ValueError:
			es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen You entered an invalid value for beacon size.')
			return
		kp_settings.change('knifep3n_beacon_size', x)
		es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen Beacon radius has been set to '+str(x))
	else:
		es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen Type @kp_helper for help.')

def set_bot_vote():
	'''
	Set how bots vote
	'''
	userid = es.getcmduserid()
	# needs 2 args, command and votetype
	if (es.getargc() == 2):
		# x is percentage of yes votes, y is setting behavior
		if (x == 100) or (x == 1):
			y = 1
		elif (x == 66) or (x == 3):
			y = 3
		elif (x == 50) or (x == 2):
			y = 2
		elif (x == 0) or (x == 4):
			y = 4
		# fallback to ALWAYS YES if nothing else fits
		else:
			y = 1
			x = 100
		kp_settings.change('knifep3n_bot_vote', x)
		es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen Bots will now vote yes '+str(x)+' percent of the time.')
	else:
		es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen Type @kp_helper for help.')

def set_time_limit():
	'''
	Set how many seconds a fight should last for
	'''
	userid = es.getcmduserid()
	# needs 2 args, command and time
	if (es.getargc() == 2):
		try:
			x = int(es.getargv(1))
		except ValueError:
			es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen You entered an invalid value for fight time limit.')
			return
		# x is time in seconds, don't set it to less than 10
		if (x < 10):
			x = 10
		if (server_var['knifep3n_time_limit'] == server_var['knifep3n_time_limitr']):
			es.set("knifep3n_time_limitr", x)
			kp_settings.change('knifep3n_time_limit', x)
			es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen Fight time limit has been set to '+str(x))
		else:
			kp_settings.change('knifep3n_time_limit', x)
			es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen Fight time limit will be set to '+str(x)+' starting next round.')
	else:
		es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen Type @kp_helper for help.')

def set_awards():
	'''
	Set awards for knife fights
	'''
	userid = es.getcmduserid()
	# needs 3 args, command, option, and value
	if (es.getargc() == 3):
		x = es.getargv(1)
		if (x in "cash,money"):
			try:
				y = int(es.getargv(2))
			except ValueError:
				es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen You entered an invalid value for award cash.')
				return
			if (y > 16000):
				y = 16000
			if (y < 0):
				y = 0
			kp_settings.change('knifep3n_cash', y)
			es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen Knife fight winners will receive '+str(y)+' in cash!')
		elif (x in "health,hp"):
			try:
				y = int(es.getargv(2))
			except ValueError:
				es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen You entered an invalid value for award health.')
				return
			kp_settings.change('knifep3n_health', y)
			es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen Knife fight winners will have '+str(y)+' extra health!')
		elif (x == "speed"):
			try:
				y = int(es.getargv(2))
			except ValueError:
				es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen You entered an invalid value for award speed.')
				return
			# don't set speed higher than 5 or less than 0
			if (y > 5):
				y = 5
			if (y < 0):
				y = 0
			kp_settings.change('knifep3n_speed', y)
			es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen Knife fight winners will have their speed multiplied by '+str(y))
	else:
		es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen Type @kp_helper for help.')

def set_chicken_color():
	'''
	Set the color of a chicken
	'''
	userid = es.getcmduserid()
	# needs 4 args, command and RGB color
	if (es.getargc() == 4):
		try:
			r = int(es.getargv(1))
			g = int(es.getargv(2))
			b = int(es.getargv(3))
		except ValueError:
			es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen You entered an invalid value for chicken color.')
			return
		if (r > 255):
			r = 255
		if (r < 0):
			r = 0
		if (g > 255):
			g = 255
		if (g < 0):
			g = 0
		if (b > 255):
			b = 255
		if (b < 0):
			b = 0
		es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen Chicken color is '+str(r)+' '+str(g)+' '+str(b))

		kp_settings.change('knifep3n_chicken_red', r)
		kp_settings.change('knifep3n_chicken_green', g)
		kp_settings.change('knifep3n_chicken_blue', b)
	elif (es.getargc() == 2):
		parts = str(es.getargv(1)).split(' ',2)
		try:
			r = int(parts[0])
			g = int(parts[1])
			b = int(parts[2])
		except ValueError:
			es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen You entered an invalid value for chicken color.')
			return
		if (r > 255):
			r = 255
		if (r < 0):
			r = 0
		if (g > 255):
			g = 255
		if (g < 0):
			g = 0
		if (b > 255):
			b = 255
		if (b < 0):
			b = 0
		es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen Chicken color is '+str(r)+' '+str(g)+' '+str(b))
		
		kp_settings.change('knifep3n_chicken_red', r)
		kp_settings.change('knifep3n_chicken_green', g)
		kp_settings.change('knifep3n_chicken_blue', b)
	else:
		es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen Type @kp_helper for help.')

def set_chicken_speed():
	'''
	Sets the speed of a chicken
	'''
	userid = es.getcmduserid()
	# needs 2 args, command and speed
	if (es.getargc() == 2):
		try:
			x = float(es.getargv(1))
		except ValueError:
			es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen You entered an invalid value for chicken speed.')
			return
		# don't set speed higher than 5 or less than 0
		if (x > 5):
			x = 5
		if (x < 0):
			x = 0
		kp_settings.change('knifep3n_chicken_speed', x)
		es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen Chickens will have their speed multiplied by '+str(x))
	else:
		es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen Type @kp_helper for help.')

def set_lame_health():
	'''
	Set how much health a player has the round after killing him or herself
	'''
	userid = es.getcmduserid()
	# needs 2 args, command and health
	if (es.getargc() == 2):
		try:
			x = int(es.getargv(1))
		except ValueError:
			es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen You entered an invalid value for lame health.')
			return
		# don't set health lower than 1
		if (x < 1):
			x = 1
		kp_settings.change('knifep3n_lame_health', x)
		es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen Players who kill themselves or cheat during a knife fight will spawn with '+str(x)+' health the following round!')
	else:
		es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen Type @kp_helper for help.')

def popup_parser(userid, pchoice, pname):
	'''
	Parses majority of popup choices
	'''
	command = pname.lstrip('knifep3n_help_')
	if command == "beacon":
		if pchoice == 1:
			command = command+"_rate"
		else:
			command = command+"_size"
	elif command == "health":
		if pchoice == 1:
			command = "fight_"+command
		else:
			command = "lame_"+command
	elif command == "chicken":
		if pchoice == 1:
			command = command+"_color"
		else:
			command = command+"_speed"

	if command in command_list:
		if command == command_list[1]:
			command = command+str(pchoice)
		elif command == command_list[7]:
			command = awards_list[pchoice]
		if kp_settings.adminAdd(userid, command):
			es.tell(userid, '#multi', '#green[KP_Helper]#lightgreen Please enter a value for '+command+' in chat.')


def say_parser(userid, fulltext, team):
	'''
	Used in combination with popup_parser to read say commands in a Mani-like fashion
	'''
	command = kp_settings.adminGet(userid)
	if command != 0:
		if command in command_list or command in awards_list:
			if command == "beacon_color1":
				parts = fulltext.split(' ', 2)
				fulltext = "@kp_beacon1 "+parts[0]+" "+parts[1]+" "+parts[2]
			elif command == "beacon_color2":
				parts = fulltext.split(' ', 2)
				fulltext = "@kp_beacon2 "+parts[0]+" "+parts[1]+" "+parts[2]
			elif command == command_list[2]:
				fulltext = "@kp_beacon_rate "+fulltext
			elif command == command_list[3]:
				fulltext = "@kp_beacon_size "+fulltext
			elif command == command_list[4]:
				fulltext = "@kp_fight_health "+fulltext
			elif command == command_list[5]:
				fulltext = "@kp_lame_health "+fulltext
			elif command == command_list[6]:
				fulltext = "@kp_time "+fulltext
			elif command in awards_list:
				fulltext = "@kp_awards "+command+" "+fulltext
			elif command == command_list[8]:
				fulltext = "@kp_chicken_color "+fulltext
			elif command == command_list[9]:
				fulltext = "@kp_chicken_speed "+fulltext
			else:
				es.tell(userid, "#multi", "#green[KP_Helper]#lightgreen There was some error in say_parser; none of the command catches matched")
				es.tell(userid, "#multi", "#green[KP_Helper]#lightgreen the command you were trying to execute. Contact your server admin and")
				es.tell(userid, "#multi", "#green[KP_Helper]#lightgreen have him or her contact Schubaal with the following information:")
				es.tell(userid, "#multi", "#green[KP_Helper]#lightgreen Command failed: "+command)
		kp_settings.adminDelete(userid)
	return userid, fulltext, team

def unload():
	'''
	Unsend/delete popups, remove say commands
	'''
	kp_help_1.unsend(playerlib.getUseridList('#all'))
	kp_help_2.unsend(playerlib.getUseridList('#all'))
	kp_help_reset.unsend(playerlib.getUseridList('#all'))
	kp_help_force.unsend(playerlib.getUseridList('#all'))
	kp_help_toggle.unsend(playerlib.getUseridList('#all'))
	kp_help_toggle_2.unsend(playerlib.getUseridList('#all'))
	kp_help_filter.unsend(playerlib.getUseridList('#all'))
	kp_help_beacon_color.unsend(playerlib.getUseridList('#all'))
	kp_help_beacon.unsend(playerlib.getUseridList('#all'))
	kp_help_health.unsend(playerlib.getUseridList('#all'))
	kp_help_time.unsend(playerlib.getUseridList('#all'))
	kp_help_awards.unsend(playerlib.getUseridList('#all'))
	kp_help_chicken.unsend(playerlib.getUseridList('#all'))
	kp_help_bots.unsend(playerlib.getUseridList('#all'))
	
	popuplib.delete('knifep3n_help_1')
	popuplib.delete('knifep3n_help_2')
	popuplib.delete('knifep3n_help_reset')
	popuplib.delete('knifep3n_help_force')
	popuplib.delete('knifep3n_help_toggle')
	popuplib.delete('knifep3n_help_toggle_2')
	popuplib.delete('knifep3n_help_filter')
	popuplib.delete('knifep3n_help_beacon_color')
	popuplib.delete('knifep3n_help_beacon')
	popuplib.delete('knifep3n_help_health')
	popuplib.delete('knifep3n_help_time')
	popuplib.delete('knifep3n_help_awards')
	popuplib.delete('knifep3n_help_chicken')
	popuplib.delete('knifep3n_help_bots')
	
	es.unregsaycmd('@kp_reset')
	es.unregsaycmd('@kp_force')
	es.unregsaycmd('@kp_toggle')
	es.unregsaycmd('@kp_filter')
	es.unregsaycmd('@kp_fight_health')
	es.unregsaycmd('@kp_beacon1')
	es.unregsaycmd('@kp_beacon2')
	es.unregsaycmd('@kp_beacon_rate')
	es.unregsaycmd('@kp_beacon_size')
	es.unregsaycmd('@kp_bots')
	es.unregsaycmd('@kp_time')
	es.unregsaycmd('@kp_awards')
	es.unregsaycmd('@kp_chicken_color')
	es.unregsaycmd('@kp_chicken_speed')
	es.unregsaycmd('@kp_lame_health')
	es.unregsaycmd('@kp_helper')
	
	es.addons.unregisterSayFilter(say_parser)
