#pragma semicolon 1
#include <sourcemod>
#include <adminmenu>
#include <sdktools>
#include <sdkhooks>
#include <cstrike> 

public Plugin:myinfo = 
{
	name = "Player Weapon Blocker",
	author = "KOROVKA", // Plugin by KOROVKA
	description = "Block access to weapons for the player (Temporarily or permanently)",
	version = "2.1.5",
	url = ""
};

#define CONFIG_FILE "addons/sourcemod/configs/player_weapon_blocker/player_weapon_blocker.txt"

static const String:sColors[][] = { ".x07", ".x01", ".x02", ".x03", ".x04", ".x05", ".x06", ".x08", ".x09", ".x10", ".x0B", ".x0C", ".x0E" };
				
static const String:sColorsReplacement[][] = { "\x07", "\x01", "\x02", "\x03", "\x04", "\x05", "\x06", "\x08", "\x09", "\x10", "\x0B", "\x0C", "\x0E" };

new bool:g_StatusSelectMenu[MAXPLAYERS+1], bool:g_StatusWeaponDroped[MAXPLAYERS+1];
new Handle:g_hDbLocal;
new g_cTime[MAXPLAYERS+1], g_cTimeBlock[MAXPLAYERS+1];
new Handle:hTopMenu;
new g_TargetUserId[MAXPLAYERS+1], g_AdminIndex[MAXPLAYERS+1];
new Handle:TimerCheckUnBan[MAXPLAYERS+1];

new Handle:g_hOnPlayerWeaponBlocker;

new NumberWeapons;

static String:sAdminInfo[MAXPLAYERS+1][5][328];
static String:sFlagsAccess[22], String:sFlagsAnnouncement[22];

static String:sWeaponNames[MAXPLAYERS+1][328], String:sWeaponNamesAdmin[MAXPLAYERS+1][328];

static String:WeaponNames[50][10];

static String:sGame[10];
static String:Color1[12], String:Color2[12], String:Color3[12], String:Color4[12];

String:NumToName(num, type)
{
	static const String:TimeNames[][][] = { {"день", "дня", "дней"}, {"час", "часа", "часов"}, {"минута", "минуты", "минут"}, {"секунда", "секунды", "секунд"} };
	
	new String:buffer[128];
	switch(num)
	{
		case 0:		{}
        case 1:		FormatEx(buffer, 128, "1 %s", TimeNames[type][0]);
        case 2,3,4: FormatEx(buffer, 128, "%i %s", num, TimeNames[type][1]);
        default:
        {
			if(num < 21) FormatEx(buffer, 128, "%i %s", num, TimeNames[type][2]);
			else
			{
				switch(num % 10)
				{
					case 1:		FormatEx(buffer, 128, "%i %s", num, TimeNames[type][0]);
					case 2,3,4: FormatEx(buffer, 128, "%i %s", num, TimeNames[type][1]);
					default:	FormatEx(buffer, 128, "%i %s", num, TimeNames[type][2]);
				}
			}
		}
	}
	return buffer;
}

public APLRes:AskPluginLoad2(Handle:myself, bool:late, String:error[], err_max)
{
	CreateNative("IsClientInWeaponBlock", Native_IsClientInWeaponBlock);
	CreateNative("GetClientTimeWeaponBlock", Native_GetClientTimeWeaponBlock);
	CreateNative("GetClientBlockTimeWeapon", Native_GetClientBlockTimeWeapon);
	CreateNative("SetClientWeaponBlock", Native_SetClientWeaponBlock);
}

public Native_IsClientInWeaponBlock(Handle:plugin, numParams)
{
	new target = GetNativeCell(1);
	if(g_cTime[target] == 0 || g_cTime[target] > GetTime()) return true;
	return false;
}

public Native_GetClientTimeWeaponBlock(Handle:plugin, numParams)
{
	return g_cTime[GetNativeCell(1)];
}

public Native_GetClientBlockTimeWeapon(Handle:plugin, numParams)
{
	return g_cTimeBlock[GetNativeCell(1)];
}

public Native_SetClientWeaponBlock(Handle:plugin, numParams) 
{
	decl String:sWeapons[328];
	new target = GetNativeCell(1);
	GetNativeString(3, sWeapons, 328);
	DB_InsertPlayer(target, GetNativeCell(2), sWeapons);
	
	if(GetNativeCell(4) == 1) DropWeapons(target);
}

public Forward_OnPlayerWeaponBlocker(client, admin)
{
	Call_StartForward(g_hOnPlayerWeaponBlocker);
	Call_PushCell(client);
	Call_PushCell(admin);
	Call_PushString(sWeaponNames[client]);
	Call_Finish();
}

public OnPluginStart()
{
	switch(GetEngineVersion()) 
	{ 
		case Engine_CSS: sGame = "css";
		case Engine_SourceSDK2006: sGame = "css_v34";
		case Engine_CSGO: sGame = "csgo";
		default: SetFailState("Сорян, в этой игре плагин работать не будет! Поддержка только: css v34, css steam, cs:go - by KOROVKA");
	}
	
	decl String:sError[128];
	g_hDbLocal = SQLite_UseDatabase("player_weapon_blocker by.korovka", sError, 128);
	SQL_FastQuery(g_hDbLocal, "CREATE TABLE IF NOT EXISTS data (steamid varchar(20) PRIMARY KEY, name varchar(64), unix int(10), unix2 int(10), weapons varchar(328));");
	if(g_hDbLocal == INVALID_HANDLE || sError[0]) LogError("Не удалось установить соединение с БД! \n%s", sError);
	
	g_hOnPlayerWeaponBlocker = CreateGlobalForward("OnPlayerWeaponBlocker", ET_Ignore, Param_Cell, Param_Cell, Param_String);
}

public OnMapStart()
{
	new Handle:kv = CreateKeyValues("Player Weapon Blocker");
	
	if(!FileToKeyValues(kv, CONFIG_FILE)) SetFailState("Конфиг по адресу %s не найден!", CONFIG_FILE);
	
	KvRewind(kv);
	
	KvGetString(kv, "flags_access", sFlagsAccess, 22);
	KvGetString(kv, "flags_announcement", sFlagsAnnouncement, 22);
	
	if(KvJumpToKey(kv, sGame, false))
	{
		decl String:sWeapons[378];
		
		KvGetString(kv, "Color1", Color1, 12);
		KvGetString(kv, "Color2", Color2, 12);
		KvGetString(kv, "Color3", Color3, 12);
		KvGetString(kv, "Color4", Color4, 12);
		
		for (new i = 0; i < sizeof(sColors); i++)
		{
			if(ReplaceString(Color1, 12, sColors[i], sColorsReplacement[i], false) != 0) break;
		}
		
		for (new i = 0; i < sizeof(sColors); i++)
		{
			if(ReplaceString(Color2, 12, sColors[i], sColorsReplacement[i], false) != 0) break;
		}
		
		for (new i = 0; i < sizeof(sColors); i++)
		{
			if(ReplaceString(Color3, 12, sColors[i], sColorsReplacement[i], false) != 0) break;
		}
		
		for (new i = 0; i < sizeof(sColors); i++)
		{
			if(ReplaceString(Color4, 12, sColors[i], sColorsReplacement[i], false) != 0) break;
		}
		
		KvGetString(kv, "Weapons", sWeapons, 378);
		
		NumberWeapons = ExplodeString(sWeapons, ",", WeaponNames, 328, 10);
	}
	
	CloseHandle(kv);
	
	static bool:MenuCreated;
	if(MenuCreated == false)
	{
		if(LibraryExists("adminmenu") && (hTopMenu = GetAdminTopMenu()) != INVALID_HANDLE) 
		{
			MenuCreated = true;
			
			new Flags = ReadFlagString(sFlagsAccess);
			
			new TopMenuObject:player_weapon_blocker = FindTopMenuCategory(hTopMenu, "player_weapon_blocker");
			player_weapon_blocker = AddToTopMenu(hTopMenu, "category_player_weapon_blocker", TopMenuObject_Category, AdminMenu_CategoryPlayerWeaponBlocker, INVALID_TOPMENUOBJECT);
		
			AddToTopMenu(hTopMenu, "player_weapon_block", TopMenuObject_Item, AdminMenu_PlayerWeaponBlock, player_weapon_blocker, "player_weapon_block", Flags);
			AddToTopMenu(hTopMenu, "player_weapon_block_list", TopMenuObject_Item, AdminMenu_PlayerWeaponBlockList, player_weapon_blocker, "player_weapon_block_list", Flags);
		}
	}
}

public Action:WeaponCanUse(client, weapon) 
{
	if(weapon != -1)
	{
		decl String:sWeaponName[16];
		GetEntityClassname(weapon, sWeaponName, 16);
		ReplaceString(sWeaponName, 16, "weapon_", "", false);
	
		if(StrContains(sWeaponNames[client], sWeaponName, false) != -1) return Plugin_Handled;
	}
	
	return Plugin_Continue;
}

public Action:WeaponDrop(client, weapon)
{
	if(weapon != -1 && g_StatusWeaponDroped[client] == false)
	{
		decl String:sWeaponName[16];
		GetEntityClassname(weapon, sWeaponName, 16);
		ReplaceString(sWeaponName, 16, "weapon_", "", false);
	
		if(StrContains(sWeaponNames[client], sWeaponName, false) != -1) return Plugin_Handled;
	}
	
	return Plugin_Continue;
}

public PreThink(client)
{
	decl String:sWeaponName[16];
	GetClientWeapon(client, sWeaponName, 16);
	ReplaceString(sWeaponName, 16, "weapon_", "", false);
	
	if(StrContains(sWeaponNames[client], sWeaponName, false) != -1)
	{
		new buttons = GetClientButtons(client);
		if(buttons & IN_ATTACK)
		{
			buttons &= ~IN_ATTACK;
			SetEntProp(client, Prop_Data, "m_nButtons", buttons);
		}
		if(buttons & IN_ATTACK2)
		{
			buttons &= ~IN_ATTACK2;
			SetEntProp(client, Prop_Data, "m_nButtons", buttons);
		}
	}
}

public AdminMenu_CategoryPlayerWeaponBlocker(Handle:topmenu, TopMenuAction:action, TopMenuObject:object_id, client, String:buffer[], maxlength) 
{
	switch(action)
	{
		case TopMenuAction_DisplayOption: FormatEx(buffer, maxlength, "Управление оружием игроков");
		case TopMenuAction_DisplayTitle: FormatEx(buffer, maxlength, "Управление оружием игроков:");
	}
}

public AdminMenu_PlayerWeaponBlock(Handle:topmenu, TopMenuAction:action, TopMenuObject:object_id, client, String:buffer[], maxlength) 
{
	switch(action)
	{
		case TopMenuAction_DisplayOption: FormatEx(buffer, maxlength, "Заблокировать оружие игроку");
		case TopMenuAction_SelectOption: DisplayPlayerWeaponBlockerMenu(client);
	}
}

public AdminMenu_PlayerWeaponBlockList(Handle:topmenu, TopMenuAction:action, TopMenuObject:object_id, client, String:buffer[], maxlength) 
{
	switch(action)
	{
		case TopMenuAction_DisplayOption: FormatEx(buffer, maxlength, "Управление игроками с блокировкой");
		case TopMenuAction_SelectOption: DisplayPlayersInfoListWeaponBlockerMenu(client);
	}
}

DisplayPlayersInfoListWeaponBlockerMenu(client)
{
	decl String:sQuery[60];
	FormatEx(sQuery, 60, "SELECT steamid, name, unix, unix2, weapons FROM data;");
	SQL_TQuery(g_hDbLocal, SQL_SelectPlayersInfoListCallback, sQuery, client);
}

public SQL_SelectPlayersInfoListCallback(Handle:owner, Handle:hndl, const String:error[], any:client)
{
	if(hndl == INVALID_HANDLE || error[0]) LogError("[Player Weapon Blocker] Не удалось загрузить игроков с блокировой! \n%s", error);
	else
	{
		new count = SQL_GetRowCount(hndl);
		
		if(count != 0)
		{
			new Handle:menu = CreateMenu(MenuHandler_PlayersInfoList);

			SetMenuTitle(menu, "Управление игроками с блокировкой:");
			SetMenuExitBackButton(menu, true);
		
			decl String:buffer[80], String:info[436], String:sSteamID[20], String:sName[64], String:sWeapons[328];

			for (new i = 1; i <= count; i++)
			{
				if(SQL_FetchRow(hndl))
				{		
					new unix = SQL_FetchInt(hndl, 2);
			
					if(unix != 1)
					{
						SQL_FetchString(hndl, 0, sSteamID, 20);
						SQL_FetchString(hndl, 1, sName, 64);
						SQL_FetchString(hndl, 4, sWeapons, 328);
				
						FormatEx(buffer, 80, "%s [%s]", sName, unix == 0 ? "Навсегда":"Временный");
					
						FormatEx(info, 436, "%s,%s,%d,%d,%s", sSteamID, sName, unix, SQL_FetchInt(hndl, 3), sWeapons);
		
						AddMenuItem(menu, info, buffer);
					}
					else if(i == count)
					{
						DisplayTopMenu(hTopMenu, client, TopMenuPosition_LastCategory);
						PrintToChat(client, "%s[Player Weapon Blocker] %sИгроков с блокировкой оружия не найдено!", Color1, Color2);
						return;
					}
				}
			}
			
			DisplayMenu(menu, client, MENU_TIME_FOREVER);
		}
		else 
		{
			DisplayTopMenu(hTopMenu, client, TopMenuPosition_LastCategory);
			PrintToChat(client, "%s[Player Weapon Blocker] %sБаза данных пустая!", Color1, Color2);
		}
	}
}

public MenuHandler_PlayersInfoList(Handle:menu, MenuAction:action, param1, param2) 
{
	switch(action)
	{
		case MenuAction_Select:
		{
			decl String:info[436];
			GetMenuItem(menu, param2, info, 436);
				
			ExplodeString(info, ",", sAdminInfo[param1], 5, 328);

			DisplayPlayerInfoWeaponBlockerMenu(param1);
		}
		case MenuAction_End: CloseHandle(menu);
		case MenuAction_Cancel: if(param2 == MenuCancel_ExitBack) DisplayTopMenu(hTopMenu, param1, TopMenuPosition_LastCategory);
	}
}

DisplayPlayerInfoWeaponBlockerMenu(client)
{
	new Handle:menu = CreateMenu(MenuHandler_PlayerInfo);
	SetMenuTitle(menu, "Информация о блокировке игрока: %s", sAdminInfo[client][1]);
	SetMenuExitBackButton(menu, true);
	
	decl String:buffer[100];
	
	new getTime = GetTime();
	
	new time = getTime - StringToInt(sAdminInfo[client][3]);
	
	if(time > 60)
	{
		FormatEx(buffer, 100, "У игрока блокировка: %s %s %s", NumToName(time/3600/24, 0), NumToName(time/3600%24, 1), NumToName(time/60%60, 2));
		AddMenuItem(menu, "", buffer, ITEMDRAW_DISABLED);
	}
	else AddMenuItem(menu, "",  "У игрока блокировка: Меньше минуты", ITEMDRAW_DISABLED);
	
	new unix = StringToInt(sAdminInfo[client][2]);
	
	if(unix != 0)
	{
		time = unix - getTime;
		FormatEx(buffer, 100, "Блокировка будет снята через: %s %s %s", NumToName(time/3600/24, 0), NumToName(time/3600%24, 1), NumToName(time/60%60, 2));
		AddMenuItem(menu, "", buffer, ITEMDRAW_DISABLED);
	}
	else AddMenuItem(menu, "", "Блокировка будет снята: Никогда", ITEMDRAW_DISABLED);
			
	FormatEx(buffer, 100, "SteamID: %s", sAdminInfo[client][0]);
	AddMenuItem(menu, "", buffer, ITEMDRAW_DISABLED);
	
	AddMenuItem(menu, "", "Изменить время блокировки оружия");
	AddMenuItem(menu, "", "Редактировать заблокированное оружие");
	AddMenuItem(menu, "", "Разблокировать оружие игрока");
	
	DisplayMenu(menu, client, MENU_TIME_FOREVER);
}

public MenuHandler_PlayerInfo(Handle:menu, MenuAction:action, param1, param2) 
{
	switch(action)
	{
		case MenuAction_Select:
		{
			if(param2 == 3) DisplayPlayerWeaponBlockerEditTimeMenu(param1);
			else if(param2 == 4) DisplayPlayerEditWeaponBlockerMenu(param1);
			else
			{
				decl String:sQuery[184], String:sSteamID[20];
				FormatEx(sQuery, 184, "INSERT OR REPLACE INTO data (steamid, name, unix, unix2, weapons) VALUES('%s', '%s', '1', '0', '');", sAdminInfo[param1][0], sAdminInfo[param1][1]);
				SQL_FastQuery(g_hDbLocal, sQuery);
					
				for (new i = 1; i <= MaxClients; i++)
				{
					if(IsClientInGame(i) && !IsFakeClient(i)) 
					{
						GetClientAuthId(i, AuthId_SteamID64, sSteamID, 20);
						if(strcmp(sAdminInfo[param1][0], sSteamID, false) == 0)
						{
							g_cTime[i] = 1;
							g_cTimeBlock[i] = 0;
							sWeaponNames[i] = "";
		
							SDKUnhook(i, SDKHook_WeaponDrop, WeaponDrop);
							SDKUnhook(i, SDKHook_WeaponCanUse, WeaponCanUse);
							SDKUnhook(i, SDKHook_PreThink, PreThink);
							KillTimerCheckUnBan(i);
								
							if(GetPlayerWeaponSlot(i, 2) == -1) GivePlayerItem(i, "weapon_knife");
							
							PrintToChat(i, "%s[Player Weapon Blocker] %sВам разблокировали доступ к оружию!", Color1, Color2);
							
							Forward_OnPlayerWeaponBlocker(i, param1);
						}
			
						if((GetUserFlagBits(i) & ReadFlagString(sFlagsAnnouncement)) && i != param1) PrintToChat(i, "%s[Player Weapon Blocker] %sАдминистратор %s%N%s разблокировал доступ к оружию игроку %s%s", Color1, Color2, Color3, param1, Color2, Color3, sAdminInfo[param1][1]);
					}
				}
					
				PrintToChat(param1, "%s[Player Weapon Blocker] %sДоступ к оружию игроку %s%s %sбыл успешно разблокирован!", Color1, Color2, Color3, sAdminInfo[param1][1], Color2);
			}
		}
		case MenuAction_End: CloseHandle(menu);
		case MenuAction_Cancel: if(param2 == MenuCancel_ExitBack) DisplayPlayersInfoListWeaponBlockerMenu(param1);
	}
}

DisplayPlayerWeaponBlockerEditTimeMenu(client)
{
	new Handle:menu = CreateMenu(MenuHandler_EditTimeList);

	SetMenuTitle(menu, "Редактирование время блокировки оружия: %s", sAdminInfo[client][1]);
	SetMenuExitBackButton(menu, true);

	AddMenuItem(menu, "0", "Навсегда");
	AddMenuItem(menu, "10", "10 минут");
	AddMenuItem(menu, "30", "30 минут");
	AddMenuItem(menu, "60", "1 час");
	AddMenuItem(menu, "240", "4 часа");
	AddMenuItem(menu, "1440", "1 день");
	AddMenuItem(menu, "10080", "1 неделя");

	DisplayMenu(menu, client, MENU_TIME_FOREVER);
}

public MenuHandler_EditTimeList(Handle:menu, MenuAction:action, param1, param2)
{
	switch(action)
	{
		case MenuAction_Select:
		{
			decl String:info[10];

			GetMenuItem(menu, param2, info, 10);
			new time = StringToInt(info);
					
			if(time == 0) PrintToChat(param1, "%s[Player Weapon Blocker] %sВремя блокировки доступа к оружию игроку %s%s %sбыло успешно изменено! %s(Навсегда)", Color1, Color2, Color3, sAdminInfo[param1][1], Color2, Color4);
			else PrintToChat(param1, "%s[Player Weapon Blocker] %sВремя блокировки доступа к оружию игроку %s%s %sбыло успешно изменено! %s(На %d минут)", Color1, Color2, Color3, sAdminInfo[param1][1], Color2, Color4, time);
				
			new Time;
				
			if(time != 0) Time = (time * 60) + GetTime();
				
			decl String:sSteamID[20], String:sQuery[540];
			for (new i = 1; i <= MaxClients; i++)
			{
				if(IsClientInGame(i) && !IsFakeClient(i)) 
				{
					GetClientAuthId(i, AuthId_SteamID64, sSteamID, 20);
					if(strcmp(sAdminInfo[param1][0], sSteamID, false) == 0) 
					{
						g_cTime[i] = Time;
							
						if(time == 0) PrintToChat(i, "%s[Player Weapon Blocker] %sВам изменили время блокировки доступа к оружию! %s(Навсегда)", Color1, Color2, Color4);
						else PrintToChat(i, "%s[Player Weapon Blocker] %sВам изменили время блокировки доступа к оружию! %s(На %d минут)", Color1, Color2, Color4, time);
							
						Forward_OnPlayerWeaponBlocker(i, param1);
					}
						
					if((GetUserFlagBits(i) & ReadFlagString(sFlagsAnnouncement)) && i != param1)
					{
						if(time == 0) PrintToChat(i, "%s[Player Weapon Blocker] %sАдминистратор %s%N%s изменил время блокировки доступа к оружию игроку %s%s %s(Навсегда)", Color1, Color2, Color3, param1, Color2, Color3, sAdminInfo[param1][1], Color4);
						else PrintToChat(i, "%s[Player Weapon Blocker] %sАдминистратор %s%N%s изменил время блокировки доступа к оружию игроку %s%s %s(На %d минут)", Color1, Color2, Color3, param1, Color2, Color3, sAdminInfo[param1][1], Color4, time);
					}
				}
			}
				
			FormatEx(sQuery, 540, "INSERT OR REPLACE INTO data (steamid, name, unix, unix2, weapons) VALUES('%s', '%s', '%d', '%d', '%s');", sAdminInfo[param1][0], sAdminInfo[param1][1], Time, StringToInt(sAdminInfo[param1][3]), sAdminInfo[param1][4]);
			SQL_FastQuery(g_hDbLocal, sQuery);
		}
		case MenuAction_End: CloseHandle(menu);
		case MenuAction_Cancel: if(param2 == MenuCancel_ExitBack) DisplayPlayerInfoWeaponBlockerMenu(param1);
	}
}

DisplayPlayerEditWeaponBlockerMenu(client, pos = 0)
{
	new Handle:menu = CreateMenu(MenuHandler_PlayerEditWeapon);

	SetMenuTitle(menu, "Редактирование блокированного оружия: %s", sAdminInfo[client][1]);
	SetMenuExitBackButton(menu, true);
	
	AddMenuItem(menu, "", "Выбрать всё");
	
	decl String:buffer[20];
		
	for (new i = 0; i < NumberWeapons; i++)
	{
		FormatEx(buffer, 20, "%s %s", WeaponNames[i], (StrContains(sAdminInfo[client][4], WeaponNames[i], false) == -1 ? "[ ]":"[X]"));
		AddMenuItem(menu, WeaponNames[i], buffer);
	}

	DisplayMenuAtItem(menu, client, pos, MENU_TIME_FOREVER);
}

public MenuHandler_PlayerEditWeapon(Handle:menu, MenuAction:action, param1, param2) 
{
	switch(action)
	{
		case MenuAction_Select:
		{
			if(param2 == 0)
			{
				for (new i = 0; i < NumberWeapons; i++)
				{
					if(StrContains(sAdminInfo[param1][4], WeaponNames[i], false) == -1) FormatEx(sAdminInfo[param1][4], 328, "%s%s", sAdminInfo[param1][4], WeaponNames[i]);
					else 
					{
						sAdminInfo[param1][4] = "";
						break;
					}
				}

				DisplayPlayerEditWeaponBlockerMenu(param1, GetMenuSelectionPosition());
			}
			else
			{
				decl String:info[10];
				GetMenuItem(menu, param2, info, 10);
							
				if(StrContains(sAdminInfo[param1][4], info, false) == -1) FormatEx(sAdminInfo[param1][4], 328, "%s%s", sAdminInfo[param1][4], info);
				else ReplaceString(sAdminInfo[param1][4], 10, info, "", false);
					
				DisplayPlayerEditWeaponBlockerMenu(param1, GetMenuSelectionPosition());
			}
				
			g_StatusSelectMenu[param1] = true;
		}
		case MenuAction_Cancel:
		{
			if(g_StatusSelectMenu[param1])
			{
				if(strlen(sAdminInfo[param1][4]) > 1)
				{	
					PrintToChat(param1, "%s[Player Weapon Blocker] %sДоступ к оружию игроку %s%s %sбыл успешно отредактирован!", Color1, Color2, Color3, sAdminInfo[param1][1], Color2);
					
					decl String:sSteamID[20], String:sQuery[540];
					for (new i = 1; i <= MaxClients; i++)
					{
						if(IsClientInGame(i) && !IsFakeClient(i)) 
						{
							GetClientAuthId(i, AuthId_SteamID64, sSteamID, 20);
							if(strcmp(sAdminInfo[param1][0], sSteamID, false) == 0) 
							{
								//g_cTime[i] = StringToInt(sAdminInfo[param1][2]);
								//g_cTimeBlock[i] = StringToInt(sAdminInfo[param1][3]);
								strcopy(sWeaponNames[i], 328, sAdminInfo[param1][4]);
								PrintToChat(i, "%s[Player Weapon Blocker] %sВам отредактировали блокировку доступа к оружию!", Color1, Color2);
								
								if(param2 != MenuCancel_ExitBack) 
								{
									g_TargetUserId[param1] = GetClientUserId(i);
									DisplayPlayerWeaponBlockerDropMenu(param1, i);
								}
							}
							
							if((GetUserFlagBits(i) & ReadFlagString(sFlagsAnnouncement)) && i != param1) PrintToChat(i, "%s[Player Weapon Blocker] %sАдминистратор %s%N%s отредактировал блокировку доступа к оружию игроку %s%s", Color1, Color2, Color3, param1, Color2, Color3, sAdminInfo[param1][1]);
						}
					}
					
					FormatEx(sQuery, 540, "INSERT OR REPLACE INTO data (steamid, name, unix, unix2, weapons) VALUES('%s', '%s', '%d', '%d', '%s');", sAdminInfo[param1][0], sAdminInfo[param1][1], StringToInt(sAdminInfo[param1][2]), StringToInt(sAdminInfo[param1][3]), sAdminInfo[param1][4]);
					SQL_FastQuery(g_hDbLocal, sQuery);
				}
				else 
				{
					decl String:sSteamID[20], String:sQuery[184];
					for (new i = 1; i <= MaxClients; i++)
					{
						if(IsClientInGame(i) && !IsFakeClient(i)) 
						{
							GetClientAuthId(i, AuthId_SteamID64, sSteamID, 20);
							if(strcmp(sAdminInfo[param1][0], sSteamID, false) == 0) 
							{
								g_cTime[i] = 1;
								g_cTimeBlock[i] = 0;
								sWeaponNames[i] = "";
								
								SDKUnhook(i, SDKHook_WeaponDrop, WeaponDrop);
								SDKUnhook(i, SDKHook_WeaponCanUse, WeaponCanUse);
								SDKUnhook(i, SDKHook_PreThink, PreThink);
								KillTimerCheckUnBan(i);
								
								if(GetPlayerWeaponSlot(i, 2) == -1) GivePlayerItem(i, "weapon_knife");
						
								PrintToChat(i, "%s[Player Weapon Blocker] %sВам разблокировали доступ к оружию!", Color1, Color2);
								
								Forward_OnPlayerWeaponBlocker(i, param1);
							}
							
							if((GetUserFlagBits(i) & ReadFlagString(sFlagsAnnouncement)) && i != param1) PrintToChat(i, "%s[Player Weapon Blocker] %sАдминистратор %s%N%s разблокировал доступ к оружию игроку %s%s", Color1, Color2, Color3, param1, Color2, Color3, sAdminInfo[param1][1]);
						}
					}
					
					PrintToChat(param1, "%s[Player Weapon Blocker] %sДоступ к оружию игроку %s%s %sбыл успешно разблокирован!", Color1, Color2, Color3, sAdminInfo[param1][1], Color2);
					
					FormatEx(sQuery, 184, "INSERT OR REPLACE INTO data (steamid, name, unix, unix2, weapons) VALUES('%s', '%s', '1', '0', '');", sAdminInfo[param1][0], sAdminInfo[param1][1]);
					SQL_FastQuery(g_hDbLocal, sQuery);
					
					DisplayPlayersInfoListWeaponBlockerMenu(param1);
				}

				g_StatusSelectMenu[param1] = false;
			}
			
			if(param2 == MenuCancel_ExitBack) DisplayPlayerInfoWeaponBlockerMenu(param1);
		}
		case MenuAction_End: CloseHandle(menu);
	}
}

DisplayPlayerWeaponBlockerMenu(client)
{
	new Handle:menu = CreateMenu(MenuHandler_PlayersList);

	SetMenuTitle(menu, "Заблокировать оружие игроку:");
	SetMenuExitBackButton(menu, true);

	AddTargetsToMenu2(menu, client, COMMAND_FILTER_NO_BOTS);

	DisplayMenu(menu, client, MENU_TIME_FOREVER);
}

public MenuHandler_PlayersList(Handle:menu, MenuAction:action, param1, param2) 
{
	switch(action)
	{
		case MenuAction_Select:
		{
			decl String:info[10];
			new userid, target;

			GetMenuItem(menu, param2, info, 10);
			userid = StringToInt(info);
			
			if((target = GetClientOfUserId(userid)) == 0)
			{
				DisplayPlayerWeaponBlockerMenu(param1);
				PrintToChat(param1, "%s[Player Weapon Blocker] %sИгрок вышел!", Color1, Color2);
			}
			else if(!CanUserTarget(param1, target)) 
			{
				DisplayPlayerWeaponBlockerMenu(param1);
				PrintToChat(param1, "%s[Player Weapon Blocker] %sИгрок не доступен!", Color1, Color2);
			}
			else
			{
				g_TargetUserId[param1] = userid;
				
				DisplayPlayerSelectWeaponBlockerMenu(param1, target);
			}
		}
		case MenuAction_End: CloseHandle(menu);
		case MenuAction_Cancel: if(param2 == MenuCancel_ExitBack) DisplayTopMenu(hTopMenu, param1, TopMenuPosition_LastCategory);
	}
}

DisplayPlayerSelectWeaponBlockerMenu(client, target, pos = 0)
{
	new Handle:menu = CreateMenu(MenuHandler_PlayerSelectWeapon);

	SetMenuTitle(menu, "Заблокировать оружие: %N", target);
	SetMenuExitBackButton(menu, true);
	
	decl String:buffer[20];
	
	AddMenuItem(menu, "", "Установить время блокировки оружия");
	AddMenuItem(menu, "", "Выбрать всё");
		
	for (new i = 0; i < NumberWeapons; i++)
	{
		FormatEx(buffer, 20, "%s %s", WeaponNames[i], (StrContains(sWeaponNamesAdmin[client], WeaponNames[i], false) == -1 ? "[ ]":"[X]"));
		AddMenuItem(menu, WeaponNames[i], buffer);
	}

	DisplayMenuAtItem(menu, client, pos, MENU_TIME_FOREVER);
}

public MenuHandler_PlayerSelectWeapon(Handle:menu, MenuAction:action, param1, param2) 
{
	switch(action)
	{
		case MenuAction_Select:
		{
			decl String:info[10];
			GetMenuItem(menu, param2, info, 10);
			new target;
				
			if((target = GetClientOfUserId(g_TargetUserId[param1])) == 0) 
			{
				PrintToChat(param1, "%s[Player Weapon Blocker] %sИгрок вышел!", Color1, Color2);
				DisplayPlayerWeaponBlockerMenu(param1);
			}
			else if(!CanUserTarget(param1, target)) 
			{
				PrintToChat(param1, "%s[Player Weapon Blocker] %sИгрок не доступен!", Color1, Color2);
				DisplayPlayerWeaponBlockerMenu(param1);
			}
			else
			{	
				if(param2 == 0)
				{
					if(strlen(sWeaponNamesAdmin[param1]) > 1) DisplayPlayerWeaponBlockerTimeMenu(param1, target);
					else 
					{
						PrintToChat(param1, "%s[Player Weapon Blocker] %sВыберите оружие которое будет блокироваться!", Color1, Color2);
						DisplayPlayerSelectWeaponBlockerMenu(param1, target, GetMenuSelectionPosition());
					}
				}
				else if(param2 == 1)
				{
					for (new i = 0; i < NumberWeapons; i++)
					{
						if(StrContains(sWeaponNamesAdmin[param1], WeaponNames[i], false) == -1) FormatEx(sWeaponNamesAdmin[param1], sizeof(sWeaponNamesAdmin[]), "%s%s", sWeaponNamesAdmin[param1], WeaponNames[i]);
						else 
						{
							sWeaponNamesAdmin[param1] = "";
							break;
						}
					}

					DisplayPlayerSelectWeaponBlockerMenu(param1, target, GetMenuSelectionPosition());
				}
				else
				{
					if(StrContains(sWeaponNamesAdmin[param1], info, false) == -1) FormatEx(sWeaponNamesAdmin[param1], sizeof(sWeaponNamesAdmin[]), "%s%s", sWeaponNamesAdmin[param1], info);
					else ReplaceString(sWeaponNamesAdmin[param1], 10, info, "", false);
					
					DisplayPlayerSelectWeaponBlockerMenu(param1, target, GetMenuSelectionPosition());
				}
			}
		}
		case MenuAction_End: CloseHandle(menu);
		case MenuAction_Cancel: if(param2 == MenuCancel_ExitBack) DisplayPlayerWeaponBlockerMenu(param1);
	}
}

DisplayPlayerWeaponBlockerTimeMenu(client, target)
{
	new Handle:menu = CreateMenu(MenuHandler_TimeList);

	SetMenuTitle(menu, "Выдать блокировку оружия: %N", target);
	SetMenuExitBackButton(menu, true);

	AddMenuItem(menu, "0", "Навсегда");
	AddMenuItem(menu, "10", "10 минут");
	AddMenuItem(menu, "30", "30 минут");
	AddMenuItem(menu, "60", "1 час");
	AddMenuItem(menu, "240", "4 часа");
	AddMenuItem(menu, "1440", "1 день");
	AddMenuItem(menu, "10080", "1 неделя");

	DisplayMenu(menu, client, MENU_TIME_FOREVER);
}

public MenuHandler_TimeList(Handle:menu, MenuAction:action, param1, param2)
{
	switch(action)
	{
		case MenuAction_Select:
		{
			decl String:info[10];

			GetMenuItem(menu, param2, info, 10);
			new time = StringToInt(info);
			new target;

			if((target = GetClientOfUserId(g_TargetUserId[param1])) == 0) 
			{
				PrintToChat(param1, "%s[Player Weapon Blocker] %sИгрок вышел!", Color1, Color2);
				DisplayPlayerWeaponBlockerMenu(param1);
			}
			else if(!CanUserTarget(param1, target)) 
			{
				PrintToChat(param1, "%s[Player Weapon Blocker] %sИгрок не доступен!", Color1, Color2);
				DisplayPlayerWeaponBlockerMenu(param1);
			}
			else
			{
				new Time;
					
				if(time == 0) 
				{
					PrintToChat(param1, "%s[Player Weapon Blocker] %sДоступ к оружию игроку %s%N %sбыл успешно заблокирован! %s(Навсегда)", Color1, Color2, Color3, target, Color2, Color4);
					PrintToChat(target, "%s[Player Weapon Blocker] %sВам заблокировали доступ к оружию! %s(Навсегда)", Color1, Color2, Color4);
				}
				else if(g_cTime[target] > 1) 
				{
					Time = ((g_cTime[target]-GetTime())/60)+time;
						
					PrintToChat(param1, "%s[Player Weapon Blocker] %sБлокировка доступа к оружию игроку %s%N %sбыла успешно продлена! %s(Время блокировки: %s)", Color1, Color2, Color3, target, Color2, Color4, NumToName(Time, 2));
					PrintToChat(target, "%s[Player Weapon Blocker] %sВам продлили блокировку доступа к оружию! %s(Время блокировки: %s)", Color1, Color2, Color4, NumToName(Time, 2));
				}
				else 
				{
					PrintToChat(param1, "%s[Player Weapon Blocker] %sДоступ к оружию игроку %s%N %sбыл успешно заблокирован! %s(На %d минут)", Color1, Color2, Color3, target, Color2, Color4, time);
					PrintToChat(target, "%s[Player Weapon Blocker] %sВам заблокировали доступ к оружию! %s(На %d минут)", Color1, Color2, Color4, time);
				}
					
				for (new i = 1; i <= MaxClients; i++)
				{
					if(IsClientInGame(i) && (GetUserFlagBits(i) & ReadFlagString(sFlagsAnnouncement)) && i != param1)
					{
						if(time == 0) PrintToChat(i, "%s[Player Weapon Blocker] %sАдминистратор %s%N%s заблокировал доступ к оружию игроку %s%N %s(Навсегда)", Color1, Color2, Color3, param1, Color2, Color3, target, Color4);
						else if(g_cTime[target] > 1) PrintToChat(i, "%s[Player Weapon Blocker] %sАдминистратор %s%N%s продлил блокировку доступа к оружию игроку %s%N %s(Время блокировки: %s)", Color1, Color2, Color3, param1, Color2, Color3, target, Color4, NumToName(Time, 2));
						else PrintToChat(i, "%s[Player Weapon Blocker] %sАдминистратор %s%N%s заблокировал доступ к оружию игроку %s%N %s(На %d минут)", Color1, Color2, Color3, param1, Color2, Color3, target, Color4, time);
					}
				}
				
				g_AdminIndex[target] = param1;
				
				DB_InsertPlayer(target, time, sWeaponNamesAdmin[param1]);
					
				DisplayPlayerWeaponBlockerDropMenu(param1, target);
					
				sWeaponNamesAdmin[param1] = "";
			}
		}
		case MenuAction_End: CloseHandle(menu);
		case MenuAction_Cancel: 
		{	
			if(param2 == MenuCancel_ExitBack) 
			{
				new target;
				if((target = GetClientOfUserId(g_TargetUserId[param1])) == 0) 
				{
					PrintToChat(param1, "%s[Player Weapon Blocker] %sИгрок вышел!", Color1, Color2);
					DisplayPlayerWeaponBlockerMenu(param1);
				}
				else DisplayPlayerSelectWeaponBlockerMenu(param1, target);
			}
		}
	}
}

DisplayPlayerWeaponBlockerDropMenu(client, target)
{
	new Handle:menu = CreateMenu(MenuHandler_PlayerDropWeapons);

	SetMenuTitle(menu, "Выбросить заблокированное оружие из рук: %N ?", target);
	SetMenuExitBackButton(menu, false);

	AddMenuItem(menu, "", "Да");
	AddMenuItem(menu, "", "Нет");

	DisplayMenu(menu, client, MENU_TIME_FOREVER);
}

public MenuHandler_PlayerDropWeapons(Handle:menu, MenuAction:action, param1, param2)
{
	switch(action)
	{
		case MenuAction_Select:
		{
			new target;

			if((target = GetClientOfUserId(g_TargetUserId[param1])) == 0) PrintToChat(param1, "%s[Player Weapon Blocker] %sИгрок вышел!", Color1, Color2);
			else if(!CanUserTarget(param1, target)) PrintToChat(param1, "%s[Player Weapon Blocker] %sИгрок не доступен!", Color1, Color2);
			else if(param2 == 0) DropWeapons(target);
		}
		case MenuAction_End: CloseHandle(menu);
	}
}

stock DropWeapons(target)
{
	g_StatusWeaponDroped[target] = true;
						
	decl String:sWeaponName[16];
	for (new slot = 0, weapon; slot <= 4; slot++)
	{
		if((weapon = GetPlayerWeaponSlot(target, slot)) != -1)
		{
			GetEntityClassname(weapon, sWeaponName, 16);
			ReplaceString(sWeaponName, 16, "weapon_", "", false);
			if(StrContains(sWeaponNames[target], sWeaponName, false) != -1) CS_DropWeapon(target, weapon, true);
		}
	}
						
	g_StatusWeaponDroped[target] = false;
}

public OnClientPutInServer(client)
{
	g_cTime[client] = 1;
	g_cTimeBlock[client] = 0;
	
	if(!IsFakeClient(client)) DB_SelectPlayer(client);
}

public OnClientDisconnect(client) 
{
	sWeaponNamesAdmin[client] = "";
	KillTimerCheckUnBan(client);
}

DB_SelectPlayer(client)
{
	decl String:sQuery[80], String:sSteamID[20];
	GetClientAuthId(client, AuthId_SteamID64, sSteamID, 20);
	FormatEx(sQuery, 80, "SELECT unix, unix2, weapons FROM data WHERE steamid = '%s';", sSteamID);
	SQL_TQuery(g_hDbLocal, SQL_SelectPlayerCallback, sQuery, client);
}

public SQL_SelectPlayerCallback(Handle:owner, Handle:hndl, const String:error[], any:client)
{
	if(hndl == INVALID_HANDLE || error[0]) LogError("[Player Weapon Blocker] Не удалось загрузить игрока! \n%s", error);
	else
	{
		if(SQL_FetchRow(hndl) && IsClientInGame(client))
		{
			new getTime;
			g_cTime[client] = SQL_FetchInt(hndl, 0);
			g_cTimeBlock[client] = SQL_FetchInt(hndl, 1);
			SQL_FetchString(hndl, 2, sWeaponNames[client], 328);
			if(g_cTime[client] == 0 || g_cTime[client] > (getTime = GetTime()))
			{
				SDKHook(client, SDKHook_WeaponCanUse, WeaponCanUse);
				SDKHook(client, SDKHook_WeaponDrop, WeaponDrop);
				SDKHook(client, SDKHook_PreThink, PreThink);
				
				if(!TimerCheckUnBan[client]) TimerCheckUnBan[client] = CreateTimer(300.0, StartTimerCheckUnBan, client, TIMER_REPEAT);
				
				if(g_cTime[client] != 0)
				{
					new time = g_cTime[client] - getTime;
					PrintToChat(client, "%s[Player Weapon Blocker] %sДо разблокировки доступа к оружию осталось: %s%s %s %s %s", Color1, Color2, Color4, NumToName(time/3600/24, 0), NumToName(time/3600%24, 1), NumToName(time/60%60, 2), NumToName(time%60, 3));
				}
			}
			else if(g_cTime[client] != 1)
			{
				DB_InsertPlayer(client, 1, "");
				KillTimerCheckUnBan(client);
				PrintToChat(client, "%s[Player Weapon Blocker] %sИстекло время блокировки доступа к оружию!", Color1, Color4);
			}
		}
	}
}

public Action:StartTimerCheckUnBan(Handle:timer, any:client) DB_SelectPlayer(client);

public KillTimerCheckUnBan(client)
{
	if(TimerCheckUnBan[client])  
	{
		KillTimer(TimerCheckUnBan[client]);  
		TimerCheckUnBan[client] = INVALID_HANDLE; 
	}
}

DB_InsertPlayer(client, time, String:sWeaponNamesAdm[])
{
	new getTime = GetTime();
	
	if(time != 1)
	{
		SDKHook(client, SDKHook_WeaponCanUse, WeaponCanUse);
		SDKHook(client, SDKHook_WeaponDrop, WeaponDrop);
		SDKHook(client, SDKHook_PreThink, PreThink);
			
		if(!TimerCheckUnBan[client]) TimerCheckUnBan[client] = CreateTimer(300.0, StartTimerCheckUnBan, client, TIMER_REPEAT);
	
		if(time != 0)
		{
			time = time * 60;
			
			if(g_cTime[client] < getTime) g_cTime[client] = getTime;
			
			g_cTime[client] += time;
		}
		else g_cTime[client] = 0;
	}
	else 
	{
		g_cTime[client] = 1;
		
		SDKUnhook(client, SDKHook_WeaponDrop, WeaponDrop);
		SDKUnhook(client, SDKHook_WeaponCanUse, WeaponCanUse);
		SDKUnhook(client, SDKHook_PreThink, PreThink);
		
		KillTimerCheckUnBan(client);
		
		if(GetPlayerWeaponSlot(client, 2) == -1) GivePlayerItem(client, "weapon_knife");
	}
	
	strcopy(sWeaponNames[client], 328, sWeaponNamesAdm);
	
	decl String:sQuery[540], String:sSteamID[20], String:sName[64];
	GetClientAuthId(client, AuthId_SteamID64, sSteamID, 20);
	GetClientName(client, sName, 64);
	
	if(g_cTimeBlock[client] == 0)
	{
		g_cTimeBlock[client] = getTime;
		FormatEx(sQuery, 540, "INSERT OR REPLACE INTO data (steamid, name, unix, unix2, weapons) VALUES('%s', '%s', '%d', '%d', '%s');", sSteamID, sName, g_cTime[client], getTime, sWeaponNamesAdm);
	}
	else if(time == 1) 
	{
		g_cTimeBlock[client] = 0;
		FormatEx(sQuery, 540, "INSERT OR REPLACE INTO data (steamid, name, unix, unix2, weapons) VALUES('%s', '%s', '1', '0', '%s');", sSteamID, sName, sWeaponNamesAdm);
	}
	else FormatEx(sQuery, 540, "INSERT OR REPLACE INTO data (steamid, name, unix, unix2, weapons) VALUES('%s', '%s', '%d', '%d', '%s');", sSteamID, sName, g_cTime[client], g_cTimeBlock[client], sWeaponNamesAdm);
	
	SQL_FastQuery(g_hDbLocal, sQuery);
	
	Forward_OnPlayerWeaponBlocker(client, g_AdminIndex[client]);
	
	g_AdminIndex[client] = 0;
}