#!/usr/bin/env python
# -*- coding: utf-8 -*-

import es
import usermsg

info = es.AddonInfo()
info.name = 'Alive Fighters'
info.version = '2.0.0'
info.url = 'http://addons.eventscripts.com/addons/user/43738'
info.basename = 'alive_fighters'
info.author = 'maniek23'
info.description   = "Displays teams count in HUD every time any player dies"

addon_tag = "#default[#greenAlive Fighters#default]"

start_t_count = 0
start_ct_count = 0

def load():
	var = es.ServerVar("%s" % info.basename)
	var.set("%s by %s - v. %s" % (info.name, info.author, info.version))
	var.makepublic()
	var = es.ServerVar("%s_version" % info.basename)
	var.set( "%s" % info.version)
	var.makepublic()
	
	es.msg('#multi', '%s Loaded' % addon_tag)
	
def unload():
	es.msg('#multi', '%s Unloaded' % addon_tag)
	
def round_start(ev):
	global start_t_count, start_ct_count
	start_t_count = es.getlivingplayercount(2)
	start_ct_count = es.getlivingplayercount(3)
	
	DisplayHUD()
	
def round_end(ev):
	DisplayHUD(t_comment='(%s)' % start_t_count, ct_comment='(%s)' % start_ct_count, display_team_names=1)
	
def player_death(ev):
	DisplayHUD()
	
def DisplayHUD(t_comment="", ct_comment="", display_team_names=-1):
		
	format_dict =   {
					't_name': 'T' if display_team_names else "",
					'ct_name': 'CT' if display_team_names else "",
					't_name_abs': 'T',
					'ct_name_abs': 'CT',
					't_comment': t_comment,
					'ct_comment': ct_comment,
					't_count': es.getlivingplayercount(2),
					'ct_count': es.getlivingplayercount(3)
					}
					
	t_hud_str = "%(t_name)s %(t_comment)s %(t_count)s vs %(ct_count)s %(ct_comment)s %(ct_name)s" % format_dict
	ct_hud_str = "%(ct_name)s %(ct_comment)s %(ct_count)s vs %(t_count)s %(t_comment)s %(t_name)s" % format_dict
	spec_hud_str = "%(t_name_abs)s %(t_comment)s %(t_count)s vs %(ct_count)s %(ct_comment)s %(ct_name_abs)s" % format_dict
	
	usermsg.hudhint('#human,#t', t_hud_str)
	usermsg.hudhint('#human,#ct', ct_hud_str)
	usermsg.hudhint('#human,#spec', spec_hud_str)
	
